/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.IdentifierProviderChangeEvent;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractDataView<T>
implements DataView<T> {
    protected static final String NULL_ITEM_ERROR_MESSAGE = "Item cannot be null";
    protected static final String NULL_IDENTIFIER_ERROR_MESSAGE = "Identity provider should not return null";
    protected SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier;
    protected Component component;

    public AbstractDataView(SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier, Component component) {
        Objects.requireNonNull(dataProviderSupplier, "DataProvider supplier cannot be null");
        this.dataProviderSupplier = dataProviderSupplier;
        this.component = component;
        Class<?> dataProviderType = ((DataProvider)dataProviderSupplier.get()).getClass();
        if (this.isDataProviderInitialized(dataProviderType)) {
            this.verifyDataProviderType(dataProviderType);
        }
    }

    @Override
    public Registration addItemCountChangeListener(ComponentEventListener<ItemCountChangeEvent<?>> listener) {
        Objects.requireNonNull(listener, "ItemCountChangeListener cannot be null");
        return ComponentUtil.addListener((Component)this.component, ItemCountChangeEvent.class, listener);
    }

    protected abstract Class<?> getSupportedDataProviderType();

    protected final void verifyDataProviderType(Class<?> dataProviderType) {
        Class<?> supportedDataProviderType = this.getSupportedDataProviderType();
        if (!supportedDataProviderType.isAssignableFrom(dataProviderType)) {
            String message = String.format("%s only supports '%s' or it's subclasses, but was given a '%s'.%nUse either 'getLazyDataView()', 'getListDataView()' or 'getGenericDataView()' according to the used data type.", this.getClass().getSimpleName(), supportedDataProviderType.getSimpleName(), dataProviderType.getSuperclass().getSimpleName());
            throw new IllegalStateException(message);
        }
    }

    @Override
    public Stream<T> getItems() {
        return ((DataProvider)this.dataProviderSupplier.get()).fetch(new Query());
    }

    @Override
    public void refreshItem(T item) {
        Objects.requireNonNull(item, NULL_ITEM_ERROR_MESSAGE);
        ((DataProvider)this.dataProviderSupplier.get()).refreshItem(item);
    }

    @Override
    public void refreshAll() {
        ((DataProvider)this.dataProviderSupplier.get()).refreshAll();
    }

    @Override
    public void setIdentifierProvider(IdentifierProvider<T> identifierProvider) {
        Objects.requireNonNull(identifierProvider, "Item identity provider cannot be null");
        ComponentUtil.setData((Component)this.component, IdentifierProvider.class, identifierProvider);
        ComponentUtil.fireEvent((Component)this.component, new IdentifierProviderChangeEvent<T, Component>(this.component, identifierProvider));
    }

    protected IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this.component, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider dataProvider = (DataProvider)this.dataProviderSupplier.get();
            if (dataProvider != null) {
                return dataProvider::getId;
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    public Registration addIdentifierProviderChangeListener(ComponentEventListener<IdentifierProviderChangeEvent<T, ?>> listener) {
        Objects.requireNonNull(listener, "IdentifierProviderChangeListener cannot be null");
        return ComponentUtil.addListener((Component)this.component, IdentifierProviderChangeEvent.class, listener);
    }

    protected boolean equals(T item, T compareTo) {
        return Objects.equals(Objects.requireNonNull(this.getIdentifierProvider().apply(item), NULL_IDENTIFIER_ERROR_MESSAGE), Objects.requireNonNull(this.getIdentifierProvider().apply(compareTo), NULL_IDENTIFIER_ERROR_MESSAGE));
    }

    private boolean isDataProviderInitialized(Class<?> dataProviderType) {
        return !DataCommunicator.EmptyDataProvider.class.isAssignableFrom(dataProviderType);
    }
}

