/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;

public class OnDisconnectInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);
    private AsynchronousProcessor p;

    @Override
    public void configure(AtmosphereConfig config) {
        if (AsynchronousProcessor.class.isAssignableFrom(config.framework().getAsyncSupport().getClass())) {
            this.p = (AsynchronousProcessor)AsynchronousProcessor.class.cast(config.framework().getAsyncSupport());
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        String s = request.getHeader("X-Atmosphere-Transport");
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        if (this.p != null && s != null && uuid != null && s.equalsIgnoreCase("close")) {
            this.logger.trace("AtmosphereResource {} disconnected", (Object)uuid);
            AtmosphereResource ss = AtmosphereResourceFactory.getDefault().find(uuid);
            if (ss != null) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ss)).getRequest(false).setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, null);
                ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(ss.getAtmosphereResourceEvent())).isClosedByClient(true);
                this.p.completeLifecycle(ss, false);
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Browser disconnection detection";
    }
}

