/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.AtmosphereFilterChain;
import org.atmosphere.util.FilterConfigImpl;

public class ReflectorServletProcessor
extends AbstractReflectorAtmosphereHandler
implements AtmosphereServletProcessor {
    private static final String APPLICATION_NAME = "applicationClassName";
    private static final Logger logger = LoggerFactory.getLogger(ReflectorServletProcessor.class);
    private String servletClassName;
    private final HashMap<String, String> filtersClassAndNames = new HashMap();
    private final HashSet<Filter> filters = new HashSet();
    private final FilterChainServletWrapper wrapper = new FilterChainServletWrapper();
    private final AtmosphereFilterChain filterChain = new AtmosphereFilterChain();
    private Servlet servlet;

    public ReflectorServletProcessor() {
    }

    public ReflectorServletProcessor(Servlet servlet) {
        this.servlet = servlet;
    }

    void loadWebApplication(ServletConfig sc) throws MalformedURLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        URL url = sc.getServletContext().getResource("/WEB-INF/lib/");
        URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        this.loadServlet(sc, urlC);
        if (!this.filters.isEmpty()) {
            this.loadFilterInstances(sc);
        } else {
            this.loadFilterClasses(sc, urlC);
        }
    }

    private void loadServlet(ServletConfig sc, URLClassLoader urlC) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.servletClassName != null && this.servlet == null) {
            try {
                this.servlet = (Servlet)urlC.loadClass(this.servletClassName).newInstance();
            }
            catch (NullPointerException ex) {
                this.servlet = (Servlet)Thread.currentThread().getContextClassLoader().loadClass(this.servletClassName).newInstance();
            }
            InjectorProvider.getInjector().inject(this.servlet);
        }
        logger.info("Installing Servlet {}", (Object)this.servletClassName);
        this.filterChain.setServlet(sc, this.servlet);
    }

    private void loadFilterClasses(ServletConfig sc, URLClassLoader urlC) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (Map.Entry<String, String> fClassAndName : this.filtersClassAndNames.entrySet()) {
            String fClass = fClassAndName.getKey();
            String filterName = fClassAndName.getValue();
            Filter f = this.loadFilter(urlC, fClass);
            InjectorProvider.getInjector().inject(f);
            if (filterName == null) {
                filterName = sc.getInitParameter(APPLICATION_NAME) != null ? sc.getInitParameter(APPLICATION_NAME) : f.getClass().getSimpleName();
            }
            FilterConfigImpl fc = new FilterConfigImpl(sc);
            fc.setFilter(f);
            fc.setFilterName(filterName);
            this.filterChain.addFilter(fc);
            logger.info("Installing Filter {}", (Object)filterName);
        }
    }

    private Filter loadFilter(URLClassLoader urlC, String fClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Filter f;
        try {
            f = (Filter)urlC.loadClass(fClass).newInstance();
        }
        catch (NullPointerException ex) {
            f = (Filter)Thread.currentThread().getContextClassLoader().loadClass(fClass).newInstance();
        }
        return f;
    }

    private void loadFilterInstances(ServletConfig sc) {
        for (Filter f : this.filters) {
            FilterConfigImpl fc = new FilterConfigImpl(sc);
            fc.setFilter(f);
            fc.setFilterName(f.getClass().getSimpleName());
            this.filterChain.addFilter(fc);
            logger.info("Installing Filter {}", (Object)f.getClass().getSimpleName());
        }
    }

    @Override
    public void onRequest(AtmosphereResource r) throws IOException {
        r.getRequest().setAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE, r);
        r.getRequest().setAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER, this);
        try {
            this.wrapper.service((ServletRequest)r.getRequest(), (ServletResponse)r.getResponse());
        }
        catch (Throwable ex) {
            logger.error("onRequest()", ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        try {
            this.loadWebApplication(sc);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        this.wrapper.init(sc);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public void destroy() {
        this.filterChain.destroy();
    }

    @Deprecated
    public String getServletClass() {
        return this.servletClassName;
    }

    @Deprecated
    public void setServletClass(String servletClass) {
        this.servletClassName = servletClass;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String servletClass) {
        this.servletClassName = servletClass;
    }

    public void setFilterClassName(String filterClass) {
        if (filterClass == null) {
            return;
        }
        this.filtersClassAndNames.put(filterClass, filterClass);
    }

    public void addFilterClassName(String filterClass, String filterName) {
        if (filterClass == null || filterName == null) {
            return;
        }
        this.filtersClassAndNames.put(filterClass, filterName);
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class FilterChainServletWrapper
    extends HttpServlet {
        private FilterChainServletWrapper() {
        }

        public void destroy() {
            ReflectorServletProcessor.this.filterChain.destroy();
        }

        public String getInitParameter(String name) {
            return this.getServletConfig().getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.getServletConfig().getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig();
        }

        public ServletContext getServletContext() {
            return this.getServletConfig().getServletContext();
        }

        public String getServletInfo() {
            return ReflectorServletProcessor.this.filterChain.getServlet().getServletInfo();
        }

        public void init(ServletConfig sc) throws ServletException {
            ReflectorServletProcessor.this.filterChain.init();
        }

        public void init() throws ServletException {
        }

        public void log(String msg) {
            this.getServletContext().log(this.getServletName() + ": " + msg);
        }

        public void log(String message, Throwable t) {
            this.getServletContext().log(this.getServletName() + ": " + message, t);
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            ReflectorServletProcessor.this.filterChain.invokeFilterChain(req, res);
        }

        public String getServletName() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig().getServletName();
        }
    }
}

