/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Jetty9WebSocketHandler;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.ServletWebSocketRequest;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class Jetty9AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(Jetty9AsyncSupportWithWebSocket.class);
    private final WebSocketServerFactory webSocketFactory;

    public Jetty9AsyncSupportWithWebSocket(final AtmosphereConfig config) {
        super(config);
        String max;
        String bs = config.getInitParameter("org.atmosphere.websocket.bufferSize");
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        if (bs != null) {
            policy.setInputBufferSize(Integer.parseInt(bs));
        }
        if ((max = config.getInitParameter("org.atmosphere.websocket.maxIdleTime")) != null) {
            policy.setIdleTimeout((long)Integer.parseInt(max));
        }
        String serverInfo = config.getServletConfig().getServletContext().getServerInfo();
        boolean isJetty91 = false;
        if (serverInfo != null && serverInfo.indexOf("9.1") != -1) {
            isJetty91 = true;
        }
        max = config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize");
        try {
            Method m;
            if (max != null) {
                m = isJetty91 ? policy.getClass().getMethod("setMaxTextMessageSize", Integer.TYPE) : policy.getClass().getMethod("setMaxMessageSize", Integer.TYPE);
                m.invoke((Object)policy, Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize")) != null) {
                m = isJetty91 ? policy.getClass().getMethod("setMaxBinaryMessageSize", Integer.TYPE) : policy.getClass().getMethod("setMaxMessageSize", Integer.TYPE);
                m.invoke((Object)policy, Integer.parseInt(max));
            }
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
        final WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        this.webSocketFactory = new WebSocketServerFactory(policy){

            public boolean acceptWebSocket(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
                this.setCreator(new WebSocketCreator(){

                    public Object createWebSocket(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse) {
                        ServletWebSocketRequest r = (ServletWebSocketRequest)ServletWebSocketRequest.class.cast(upgradeRequest);
                        r.getExtensions().clear();
                        if (!webSocketProcessor.handshake(request)) {
                            try {
                                response.sendError(403, "WebSocket requests rejected.");
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                            return null;
                        }
                        return new Jetty9WebSocketHandler(request, config.framework(), webSocketProcessor);
                    }

                    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                        req.getExtensions().clear();
                        if (!webSocketProcessor.handshake(request)) {
                            try {
                                response.sendError(403, "WebSocket requests rejected.");
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                            return null;
                        }
                        return new Jetty9WebSocketHandler(request, config.framework(), webSocketProcessor);
                    }
                });
                return super.acceptWebSocket(request, response);
            }
        };
        try {
            this.webSocketFactory.start();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = null;
        Boolean b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED);
        if (b == null) {
            b = Boolean.FALSE;
        }
        if (!Utils.webSocketEnabled((HttpServletRequest)req) && req.getAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE) == null) {
            if (req.resource() != null && req.resource().transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                WebSocket.notSupported(req, res);
                return Action.CANCELLED;
            }
            return super.service(req, res);
        }
        if (this.webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, true);
            this.webSocketFactory.acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            req.setAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE, true);
            return new Action();
        }
        action = this.suspended(req, res);
        if (action.type() != Action.TYPE.SUSPEND && action.type() == Action.TYPE.RESUME) {
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

