/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.glassfish.grizzly.comet.CometContext;
import org.glassfish.grizzly.comet.CometEngine;
import org.glassfish.grizzly.comet.CometEvent;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.http.server.Response;

public class Grizzly2CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Grizzly2CometSupport.class);
    private static final String ATMOSPHERE = "/atmosphere";
    private String atmosphereCtx = "";

    public Grizzly2CometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.atmosphereCtx = sc.getServletContext().getContextPath() + ATMOSPHERE;
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext context = cometEngine.register(this.atmosphereCtx);
        context.setExpirationDelay(-1L);
        logger.debug("Created CometContext for atmosphere context: {}", (Object)this.atmosphereCtx);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
        Action action = this.suspended(req, res);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(ctx, action, req, res);
        } else if (action.type() == Action.TYPE.RESUME) {
            this.resume(req, ctx);
        }
        return action;
    }

    private void suspend(CometContext ctx, Action action, AtmosphereRequest req, AtmosphereResponse res) {
        VoidCometHandler c = new VoidCometHandler(req, res);
        ctx.setExpirationDelay(action.timeout());
        ctx.addCometHandler((CometHandler)c);
        req.setAttribute(ATMOSPHERE, c.hashCode());
        ctx.addAttribute((Object)"Time", (Object)System.currentTimeMillis());
        if (this.supportSession()) {
            req.getSession().setAttribute(ATMOSPHERE, (Object)c.hashCode());
        }
    }

    private void resume(AtmosphereRequest req, CometContext ctx) {
        if (req.getAttribute(ATMOSPHERE) == null) {
            return;
        }
        CometHandler handler = Grizzly2CometSupport.getCometHandler(ctx, (Integer)req.getAttribute(ATMOSPHERE));
        req.removeAttribute(ATMOSPHERE);
        if (handler == null && this.supportSession() && req.getSession(false) != null) {
            handler = Grizzly2CometSupport.getCometHandler(ctx, (Integer)req.getSession(false).getAttribute(ATMOSPHERE));
            req.getSession().removeAttribute(ATMOSPHERE);
        }
        if (handler != null && (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false"))) {
            try {
                ctx.resumeCometHandler(handler);
            }
            catch (IOException e) {
                logger.error("Error resuming CometHandler", (Throwable)e);
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
            this.resume(r.getRequest(), ctx);
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            this.resume(req, CometEngine.getEngine().getCometContext(this.atmosphereCtx));
        }
        return action;
    }

    private static CometHandler getCometHandler(CometContext context, int handlerId) {
        List handlers = context.getCometHandlers();
        for (CometHandler handler : handlers) {
            if (handler.hashCode() != handlerId) continue;
            return handler;
        }
        return null;
    }

    private class VoidCometHandler
    implements CometHandler {
        AtmosphereRequest req;
        AtmosphereResponse res;
        private Response grizzlyResponse;
        CometContext cometContext;

        public VoidCometHandler(AtmosphereRequest req, AtmosphereResponse res) {
            this.req = req;
            this.res = res;
        }

        public void attach(Object o) {
        }

        public void onEvent(CometEvent ce) throws IOException {
        }

        public void onInitialize(CometEvent ce) throws IOException {
        }

        public void onTerminate(CometEvent ce) throws IOException {
        }

        public synchronized void onInterrupt(CometEvent ce) throws IOException {
            long timeStamp = (Long)ce.getCometContext().getAttribute((Object)"Time");
            try {
                if (ce.getCometContext().getExpirationDelay() > 0L && System.currentTimeMillis() - timeStamp >= ce.getCometContext().getExpirationDelay()) {
                    Grizzly2CometSupport.this.timedout(this.req, this.res);
                    this.grizzlyResponse.finish();
                } else {
                    Grizzly2CometSupport.this.cancelled(this.req, this.res);
                }
            }
            catch (ServletException ex) {
                logger.warn("onInterrupt() encountered exception", (Throwable)ex);
            }
        }

        public Response getResponse() {
            return this.grizzlyResponse;
        }

        public void setResponse(Response response) {
            this.grizzlyResponse = response;
        }

        public CometContext getCometContext() {
            return this.cometContext;
        }

        public void setCometContext(CometContext cometContext) {
            this.cometContext = cometContext;
        }
    }
}

