/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;

@AtmosphereAnnotation(value=WebSocketHandlerService.class)
public class WebSocketHandlerServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandlerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<?> annotatedClass) {
        try {
            Class<?> s = annotatedClass;
            WebSocketHandlerService m = s.getAnnotation(WebSocketHandlerService.class);
            framework.addAtmosphereHandler(m.path(), new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource resource) throws IOException {
                }

                @Override
                public void destroy() {
                }
            }).initWebSocket();
            AnnotationUtil.atmosphereConfig(m.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
            AnnotationUtil.filters(m.broadcastFilters(), framework);
            AnnotationUtil.interceptors(m.interceptors(), framework);
            AtmosphereInterceptor aa = AnnotationUtil.listeners(m.listeners(), framework);
            if (aa != null) {
                framework.interceptor(aa);
            }
            WebSocketProcessor p = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(framework);
            p.registerWebSocketHandler(m.path(), (WebSocketHandler)s.newInstance());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

