/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.AtmosphereHandlerServiceInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.util.IntrospectionUtils;

@AtmosphereAnnotation(value=AtmosphereHandlerService.class)
public class AtmosphereHandlerServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<?> annotatedClass) {
        try {
            AtmosphereInterceptor aa;
            AtmosphereHandlerService a = annotatedClass.getAnnotation(AtmosphereHandlerService.class);
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                try {
                    AtmosphereInterceptor ai = i.newInstance();
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            if (a.path().contains("{")) {
                framework.interceptors().add(new AtmosphereHandlerServiceInterceptor());
            }
            if ((aa = AnnotationUtil.listeners(a.listeners(), framework)) != null) {
                l.add(aa);
            }
            framework.sessionSupport(a.supportSession());
            AtmosphereHandler handler = (AtmosphereHandler)annotatedClass.newInstance();
            for (String s : a.properties()) {
                String[] nv = s.split("=");
                IntrospectionUtils.setProperty(handler, nv[0], nv[1]);
                IntrospectionUtils.addProperty(handler, nv[0], nv[1]);
            }
            framework.addAtmosphereHandler(a.path(), handler, l);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

