/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;

public abstract class AbstractReflectorAtmosphereHandler
implements AtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReflectorAtmosphereHandler.class);

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object message = event.getMessage();
        AtmosphereResource resource = event.getResource();
        AtmosphereResponse r = resource.getResponse();
        if (message == null) {
            logger.trace("Message was null for AtmosphereEvent {}", (Object)event);
            return;
        }
        if (event.getResource().getSerializer() != null) {
            try {
                if (message instanceof List) {
                    for (Object s : (List)message) {
                        resource.getSerializer().write((OutputStream)event.getResource().getResponse().getOutputStream(), s);
                    }
                }
                resource.getSerializer().write((OutputStream)event.getResource().getResponse().getOutputStream(), message);
            }
            catch (Throwable ex) {
                logger.warn("Serializer exception: message: " + message, ex);
                throw new IOException(ex);
            }
        } else {
            boolean isUsingStream = true;
            Object o = resource.getRequest().getAttribute("org.atmosphere.useStream");
            if (o != null) {
                isUsingStream = (Boolean)o;
            }
            if (!isUsingStream) {
                try {
                    r.getWriter();
                }
                catch (IllegalStateException e) {
                    isUsingStream = true;
                }
            }
            if (message instanceof List) {
                Iterator i = ((List)message).iterator();
                try {
                    while (i.hasNext()) {
                        Object s = i.next();
                        if (String.class.isAssignableFrom(s.getClass())) {
                            if (isUsingStream) {
                                r.getOutputStream().write(s.toString().getBytes(r.getCharacterEncoding()));
                            } else {
                                r.getWriter().write(s.toString());
                            }
                        } else if (byte[].class.isAssignableFrom(s.getClass())) {
                            if (isUsingStream) {
                                r.getOutputStream().write((byte[])s);
                            } else {
                                r.getWriter().write(s.toString());
                            }
                        } else if (isUsingStream) {
                            r.getOutputStream().write(s.toString().getBytes(r.getCharacterEncoding()));
                        } else {
                            r.getWriter().write(s.toString());
                        }
                        i.remove();
                    }
                }
                catch (IOException ex) {
                    event.setMessage(new ArrayList().addAll((List)message));
                    throw ex;
                }
                if (isUsingStream) {
                    r.getOutputStream().flush();
                } else {
                    r.getWriter().flush();
                }
            } else if (isUsingStream) {
                r.getOutputStream().write(message.toString().getBytes(r.getCharacterEncoding()));
                r.getOutputStream().flush();
            } else {
                r.getWriter().write(message.toString());
                r.getWriter().flush();
            }
        }
        this.postStateChange(event);
    }

    protected final void postStateChange(AtmosphereResourceEvent event) {
        Object o;
        if (event.isResuming() || event.isCancelled()) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        if (r == null) {
            logger.trace("Event {} returned a null AtmosphereResource", (Object)event);
            return;
        }
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
            r.resume();
        }
    }
}

