package com.vaadin.copilot.customcomponent;

import java.util.List;

import com.vaadin.copilot.JavaReflectionUtil;

/**
 * A wrapper class for custom component. <br/>
 * Custom components may be defined in multiple ways. Some can be found in
 * project source, some can be imported from an external Maven module e.g.
 * Addon. This wrapper represents all custom components and type of custom
 * component can be distinguished by {@link CustomComponent#getType()} method.
 */
public interface CustomComponent {

    /**
     * Class instance of the component
     *
     * @return Class instance
     */
    Class<?> componentClass();

    /**
     * Type of custom component.
     *
     * @return type
     */
    Type getType();

    /**
     * Checks if the component extends LitTemplate.
     *
     * @return true if it is a LitTemplate, false otherwise
     */
    boolean litTemplate();

    /**
     * List of method names where children can be added
     *
     * @return method name list
     */
    default List<CustomComponentAddMethodInfo> getChildAddableMethods() {
        return JavaReflectionUtil.getChildAddableMethods(componentClass()).stream()
                .map(componentAddableMethod -> new CustomComponentAddMethodInfo(componentAddableMethod.className(),
                        componentAddableMethod.methodName(), componentAddableMethod.paramJavaClassName()))
                .toList();
    }

    /**
     * Type of the custom component.
     */
    enum Type {
        IN_PROJECT, EXTERNAL,
    }
}
