import com.vaadin.flow.spring.security.VaadinWebSecurity;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;

@EnableWebSecurity
@Configuration
public class SecurityConfiguration extends VaadinWebSecurity {

    @Override
    protected void configure(HttpSecurity http) throws Exception {

        // Allow all access to /images/
        http.authorizeHttpRequests(authorize -> authorize
                .requestMatchers(PathPatternRequestMatcher.withDefaults().matcher("/images/*")).permitAll());

        super.configure(http);
        setLoginView(http, "/login");
    }

}