package com.vaadin.copilot.exception.report;

/**
 * Class that contains information key value pair that is useful for identifying
 * the exception.
 */
public class ExceptionReportRelevantPairData {
    private String relevance;
    private Object value;

    /**
     * Constructors a ExceptionReportRelevantPairData
     *
     * @param relevance
     *            a string representing the type or category of relevance for this
     *            data pair
     * @param value
     *            the value associated with the specified relevance.
     */
    public ExceptionReportRelevantPairData(String relevance, Object value) {
        this.relevance = relevance;
        this.value = value;
    }

    public String getRelevance() {
        return relevance;
    }

    public void setRelevance(String relevance) {
        this.relevance = relevance;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}
