package com.vaadin.copilot.customcomponent;

import java.util.Map;

/**
 * Contains all the information that is required for the UI to have custom
 * component support.
 *
 * @param allComponentsInfoForCustomComponentSupport
 *            Map that contains all components on the page with key as ID
 *            generated by flow, value as {@link CustomComponentInstanceInfo}
 *            for custom components, or
 *            {@link ComponentInfoForCustomComponentSupport} for other
 *            components that are not custom components
 */
public record CustomComponentResponseData(
        Map<Integer, ComponentInfoForCustomComponentSupport> allComponentsInfoForCustomComponentSupport) {
}
