import { ab as o } from "./copilot-Y7NsXdwP.js";
const e = {
  alertCircle: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 6V9M9 12H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  alertTriangle: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.99985 6.74999V9.75M8.99985 12.75H9.00735M7.96133 2.91878L1.79264 13.5737C1.45049 14.1647 1.27941 14.4602 1.30469 14.7028C1.32675 14.9143 1.43758 15.1065 1.6096 15.2316C1.80681 15.375 2.14826 15.375 2.83115 15.375H15.1684C15.8514 15.375 16.1928 15.375 16.39 15.2316C16.562 15.1065 16.6729 14.9143 16.6949 14.7028C16.7202 14.4602 16.5491 14.1647 16.207 13.5737L10.0383 2.91878C9.69743 2.3299 9.52695 2.03547 9.30458 1.93658C9.11055 1.85032 8.88908 1.85032 8.69513 1.93658C8.47268 2.03547 8.3022 2.32991 7.96133 2.91878Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  alignBottom: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.5 15V7.5M9 15V3M4.5 15V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  arrowLeft: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15 9H3M3 9L7.5 13.5M3 9L7.5 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  arrowRight: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3 9H15M15 9L10.5 4.5M15 9L10.5 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  atom: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.99963 9.00007H9.00713M11.6513 11.6518C8.1366 15.1665 4.10014 16.8285 2.63567 15.364C1.17121 13.8996 2.83327 9.86317 6.34799 6.34846C9.86273 2.83374 13.8992 1.17168 15.3636 2.63614C16.8281 4.10061 15.166 8.13705 11.6513 11.6518ZM11.6513 6.34832C15.166 9.86302 16.8281 13.8995 15.3636 15.3639C13.8991 16.8284 9.86265 15.1663 6.34796 11.6516C2.83324 8.1369 1.17118 4.10047 2.63564 2.63601C4.10011 1.17154 8.13653 2.8336 11.6513 6.34832ZM9.37463 9.00007C9.37463 9.20722 9.20678 9.37507 8.99963 9.37507C8.79255 9.37507 8.62463 9.20722 8.62463 9.00007C8.62463 8.793 8.79255 8.62507 8.99963 8.62507C9.20678 8.62507 9.37463 8.793 9.37463 9.00007Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  bookOpen: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 15.75L8.92493 15.6374C8.40398 14.856 8.1435 14.4652 7.79933 14.1823C7.49465 13.9319 7.14357 13.744 6.76621 13.6294C6.33994 13.5 5.87033 13.5 4.93112 13.5H3.9C3.05992 13.5 2.63988 13.5 2.31902 13.3365C2.03677 13.1927 1.8073 12.9632 1.66349 12.681C1.5 12.3602 1.5 11.9401 1.5 11.1V4.65C1.5 3.80992 1.5 3.38988 1.66349 3.06902C1.8073 2.78677 2.03677 2.5573 2.31902 2.41349C2.63988 2.25 3.05992 2.25 3.9 2.25H4.2C5.88016 2.25 6.72023 2.25 7.36197 2.57698C7.92645 2.8646 8.38538 3.32354 8.673 3.88803C9 4.52976 9 5.36984 9 7.05M9 15.75V7.05M9 15.75L9.07507 15.6374C9.59602 14.856 9.8565 14.4652 10.2007 14.1823C10.5053 13.9319 10.8564 13.744 11.2338 13.6294C11.66 13.5 12.1297 13.5 13.0689 13.5H14.1C14.9401 13.5 15.3602 13.5 15.681 13.3365C15.9632 13.1927 16.1927 12.9632 16.3365 12.681C16.5 12.3602 16.5 11.9401 16.5 11.1V4.65C16.5 3.80992 16.5 3.38988 16.3365 3.06902C16.1927 2.78677 15.9632 2.5573 15.681 2.41349C15.3602 2.25 14.9401 2.25 14.1 2.25H13.8C12.1198 2.25 11.2798 2.25 10.638 2.57698C10.0736 2.8646 9.61462 3.32354 9.327 3.88803C9 4.52976 9 5.36984 9 7.05" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  chevronLeft: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M11.25 13.5L6.75 9L11.25 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  chevronRight: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.75 13.5L11.25 9L6.75 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  chevronDown: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.5 6.75L9 11.25L13.5 6.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  chevronUp: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.5 11.25L9 6.75L4.5 11.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  clipboard: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 3C12.6975 3 13.0463 3 13.3324 3.07667C14.1088 3.28472 14.7153 3.8912 14.9234 4.66765C15 4.95378 15 5.30252 15 6V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V6C3 5.30252 3 4.95378 3.07667 4.66765C3.28472 3.8912 3.8912 3.28472 4.66765 3.07667C4.95378 3 5.30252 3 6 3M7.2 4.5H10.8C11.2201 4.5 11.4301 4.5 11.5905 4.41826C11.7317 4.34635 11.8463 4.23161 11.9182 4.09049C12 3.93006 12 3.72004 12 3.3V2.7C12 2.27996 12 2.06994 11.9182 1.90951C11.8463 1.76839 11.7317 1.65365 11.5905 1.58174C11.4301 1.5 11.2201 1.5 10.8 1.5H7.2C6.77996 1.5 6.56994 1.5 6.40951 1.58174C6.26839 1.65365 6.15365 1.76839 6.08174 1.90951C6 2.06994 6 2.27996 6 2.7V3.3C6 3.72004 6 3.93006 6.08174 4.09049C6.15365 4.23161 6.26839 4.34635 6.40951 4.41826C6.56994 4.5 6.77996 4.5 7.2 4.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  click: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_1705_14569)">
        <path d="M6.75 2.625V1.5M3.79549 3.79549L3 3M3.79549 9.75L3 10.5455M9.75 3.79549L10.5455 3M2.625 6.75H1.5M11.8984 12.1422L10.0295 15.6127C9.81607 16.0093 9.70927 16.2075 9.58087 16.2577C9.46942 16.3012 9.34388 16.2889 9.243 16.2246C9.12668 16.1505 9.06045 15.9353 8.92785 15.505L6.33389 7.08394C6.2256 6.73238 6.17145 6.5566 6.21502 6.43787C6.25297 6.33446 6.33446 6.25297 6.43787 6.21503C6.5566 6.17146 6.73237 6.2256 7.08394 6.33389L15.5049 8.92785C15.9353 9.06045 16.1504 9.12675 16.2245 9.243C16.2889 9.34395 16.3011 9.46942 16.2576 9.58087C16.2075 9.70935 16.0092 9.81607 15.6127 10.0296L12.1422 11.8984C12.0832 11.9301 12.0538 11.9459 12.028 11.9663C12.0051 11.9844 11.9844 12.0051 11.9663 12.028C11.9459 12.0538 11.9301 12.0832 11.8984 12.1422Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
        <clipPath id="clip0_1705_14569">
          <rect width="18" height="18" fill="white"/>
        </clipPath>
      </defs>
    </svg>`,
  clock: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_868_4216)">
        <path d="M9 4.5V9L12 10.5M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
        <clipPath id="clip0_868_4216">
          <rect width="18" height="18" fill="white"/>
        </clipPath>
      </defs>
    </svg>`,
  close: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12.75 5.25L5.25 12.75M5.25 5.25L12.75 12.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  code: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 13.5L16.5 9L12 4.5M6 4.5L1.5 9L6 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  copy: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_1705_14558)">
        <path d="M6 6V3.9C6 3.05992 6 2.63988 6.16349 2.31902C6.3073 2.03677 6.53677 1.8073 6.81902 1.66349C7.13988 1.5 7.55992 1.5 8.4 1.5H14.1C14.9401 1.5 15.3602 1.5 15.681 1.66349C15.9632 1.8073 16.1927 2.03677 16.3365 2.31902C16.5 2.63988 16.5 3.05992 16.5 3.9V9.6C16.5 10.4401 16.5 10.8601 16.3365 11.181C16.1927 11.4632 15.9632 11.6927 15.681 11.8365C15.3602 12 14.9401 12 14.1 12H12M3.9 16.5H9.6C10.4401 16.5 10.8601 16.5 11.181 16.3365C11.4632 16.1927 11.6927 15.9632 11.8365 15.681C12 15.3602 12 14.9401 12 14.1V8.4C12 7.55992 12 7.13988 11.8365 6.81902C11.6927 6.53677 11.4632 6.3073 11.181 6.16349C10.8601 6 10.4401 6 9.6 6H3.9C3.05992 6 2.63988 6 2.31902 6.16349C2.03677 6.3073 1.8073 6.53677 1.66349 6.81902C1.5 7.13988 1.5 7.55992 1.5 8.4V14.1C1.5 14.9401 1.5 15.3602 1.66349 15.681C1.8073 15.9632 2.03677 16.1927 2.31902 16.3365C2.63988 16.5 3.05992 16.5 3.9 16.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
        <clipPath id="clip0_1705_14558">
          <rect width="18" height="18" fill="white"/>
        </clipPath>
      </defs>
    </svg>`,
  copyAlt: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_1705_14554)">
        <path d="M7.875 1.5021C7.36871 1.50895 7.06478 1.53827 6.81902 1.66349C6.53677 1.8073 6.3073 2.03677 6.16349 2.31902C6.03827 2.56478 6.00895 2.86871 6.0021 3.375M14.625 1.5021C15.1313 1.50895 15.4352 1.53827 15.681 1.66349C15.9632 1.8073 16.1927 2.03677 16.3365 2.31902C16.4617 2.56478 16.4911 2.8687 16.4979 3.37499M16.4979 10.125C16.4911 10.6313 16.4617 10.9352 16.3365 11.181C16.1927 11.4632 15.9632 11.6927 15.681 11.8365C15.4352 11.9617 15.1313 11.9911 14.625 11.9979M16.5 5.99999V7.49999M10.5001 1.5H12M3.9 16.5H9.6C10.4401 16.5 10.8601 16.5 11.181 16.3365C11.4632 16.1927 11.6927 15.9632 11.8365 15.681C12 15.3602 12 14.9401 12 14.1V8.4C12 7.55992 12 7.13988 11.8365 6.81902C11.6927 6.53677 11.4632 6.3073 11.181 6.16349C10.8601 6 10.4401 6 9.6 6H3.9C3.05992 6 2.63988 6 2.31902 6.16349C2.03677 6.3073 1.8073 6.53677 1.66349 6.81902C1.5 7.13988 1.5 7.55992 1.5 8.4V14.1C1.5 14.9401 1.5 15.3602 1.66349 15.681C1.8073 15.9632 2.03677 16.1927 2.31902 16.3365C2.63988 16.5 3.05992 16.5 3.9 16.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
        <clipPath id="clip0_1705_14554">
          <rect width="18" height="18" fill="white"/>
        </clipPath>
      </defs>
    </svg>`,
  cursorBox: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.75 7.125V5.85C15.75 4.58988 15.75 3.95982 15.5048 3.47852C15.2891 3.05516 14.9449 2.71095 14.5215 2.49524C14.0401 2.25 13.4102 2.25 12.15 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V12.15C2.25 13.4102 2.25 14.0401 2.49524 14.5215C2.71095 14.9449 3.05516 15.2891 3.47852 15.5048C3.95982 15.75 4.58988 15.75 5.85 15.75H7.125M13.0396 13.2835L11.7659 15.649C11.5577 16.0356 11.4536 16.229 11.3267 16.2794C11.2166 16.3232 11.0922 16.3123 10.9913 16.2501C10.8751 16.1784 10.8061 15.97 10.6681 15.5531L8.6253 9.38348C8.5044 9.01838 8.44395 8.8359 8.48745 8.71432C8.52525 8.6085 8.6085 8.52525 8.71432 8.48745C8.8359 8.44395 9.01838 8.5044 9.38348 8.6253L15.5531 10.6681C15.97 10.8062 16.1784 10.8751 16.2501 10.9913C16.3123 11.0923 16.3231 11.2166 16.2793 11.3268C16.2289 11.4536 16.0356 11.5577 15.6489 11.7659L13.2835 13.0396C13.2246 13.0714 13.1951 13.0873 13.1693 13.1076C13.1464 13.1258 13.1258 13.1464 13.1076 13.1693C13.0873 13.1951 13.0714 13.2246 13.0396 13.2835Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  databaseUpload: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 6.76875C10.1125 6.76875 11.2312 6.60312 12.3562 6.27187C13.4812 5.94062 14.1125 5.60625 14.25 5.26875C14.1125 4.90625 13.4844 4.5625 12.3656 4.2375C11.2469 3.9125 10.125 3.75 9 3.75C7.8625 3.75 6.74687 3.90937 5.65312 4.22812C4.55937 4.54687 3.925 4.89375 3.75 5.26875C3.925 5.60625 4.55937 5.94062 5.65312 6.27187C6.74687 6.60312 7.8625 6.76875 9 6.76875ZM13.125 15.75H13.875V12.675L15.225 14.025L15.75 13.5L13.5 11.25L11.25 13.5L11.775 14.025L13.125 12.675V15.75ZM13.5 17.25C12.4625 17.25 11.5781 16.8844 10.8469 16.1531C10.1156 15.4219 9.75 14.5375 9.75 13.5C9.75 12.4625 10.1156 11.5781 10.8469 10.8469C11.5781 10.1156 12.4625 9.75 13.5 9.75C14.5375 9.75 15.4219 10.1156 16.1531 10.8469C16.8844 11.5781 17.25 12.4625 17.25 13.5C17.25 14.5375 16.8844 15.4219 16.1531 16.1531C15.4219 16.8844 14.5375 17.25 13.5 17.25ZM8.30625 14.2312C8.34375 14.5062 8.4 14.7687 8.475 15.0187C8.55 15.2687 8.64375 15.5125 8.75625 15.75C7.84375 15.7375 6.99375 15.65 6.20625 15.4875C5.41875 15.325 4.73125 15.1094 4.14375 14.8406C3.55625 14.5719 3.09375 14.2594 2.75625 13.9031C2.41875 13.5469 2.25 13.1625 2.25 12.75V5.25C2.25 4.425 2.90937 3.71875 4.22812 3.13125C5.54687 2.54375 7.1375 2.25 9 2.25C10.8625 2.25 12.4531 2.54375 13.7719 3.13125C15.0906 3.71875 15.75 4.425 15.75 5.25V8.75625C15.5125 8.64375 15.2687 8.55 15.0187 8.475C14.7687 8.4 14.5125 8.34375 14.25 8.30625V7.14375C13.6 7.50625 12.825 7.78125 11.925 7.96875C11.025 8.15625 10.05 8.25 9 8.25C7.9375 8.25 6.95625 8.15625 6.05625 7.96875C5.15625 7.78125 4.3875 7.50625 3.75 7.14375V9.0375C4.3875 9.625 5.20312 10.0156 6.19687 10.2094C7.19062 10.4031 8.125 10.5 9 10.5H9.20625C9.04375 10.725 8.90312 10.9625 8.78437 11.2125C8.66562 11.4625 8.5625 11.725 8.475 12C7.525 11.95 6.64375 11.8344 5.83125 11.6531C5.01875 11.4719 4.325 11.2187 3.75 10.8937V12.75C3.8375 12.9125 4.025 13.0781 4.3125 13.2469C4.6 13.4156 4.95 13.5656 5.3625 13.6969C5.775 13.8281 6.23437 13.9406 6.74062 14.0344C7.24687 14.1281 7.76875 14.1937 8.30625 14.2312Z" fill="currentColor"/>
    </svg>`,
  fileCode: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3.75 13.875C3.75 14.2233 3.75 14.3974 3.76925 14.5437C3.90218 15.5533 4.69666 16.3478 5.70631 16.4807C5.85253 16.5 6.02669 16.5 6.375 16.5H12.15C13.4102 16.5 14.0401 16.5 14.5215 16.2548C14.9449 16.0391 15.2891 15.6949 15.5048 15.2715C15.75 14.7901 15.75 14.1602 15.75 12.9V7.49117C15.75 6.94084 15.75 6.66568 15.6878 6.40673C15.6327 6.17715 15.5418 5.95767 15.4184 5.75636C15.2793 5.5293 15.0848 5.33472 14.6956 4.94558L12.3044 2.55442C11.9152 2.16527 11.7207 1.9707 11.4937 1.83156C11.2923 1.70819 11.0728 1.61729 10.8433 1.56217C10.5843 1.5 10.3091 1.5 9.75885 1.5H6.375C6.02669 1.5 5.85253 1.5 5.70631 1.51925C4.69666 1.65218 3.90218 2.44666 3.76925 3.45631C3.75 3.60253 3.75 3.77669 3.75 4.125M6.75 10.875L8.625 9L6.75 7.125M3.75 7.125L1.875 9L3.75 10.875" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  fileCodeAlt: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M10.5 1.70215V4.80005C10.5 5.22009 10.5 5.43011 10.5818 5.59055C10.6537 5.73167 10.7683 5.8464 10.9095 5.91831C11.0699 6.00005 11.2799 6.00005 11.7 6.00005H14.7979M10.5 13.125L12.375 11.25L10.5 9.375M7.5 9.375L5.625 11.25L7.5 13.125M15 7.49117V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V5.1C3 3.83988 3 3.20982 3.24524 2.72852C3.46095 2.30516 3.80516 1.96095 4.22852 1.74524C4.70982 1.5 5.33988 1.5 6.6 1.5H9.00885C9.55912 1.5 9.8343 1.5 10.0933 1.56217C10.3228 1.61729 10.5423 1.70819 10.7437 1.83156C10.9707 1.9707 11.1653 2.16527 11.5544 2.55442L13.9456 4.94558C14.3348 5.33473 14.5293 5.5293 14.6684 5.75636C14.7918 5.95767 14.8827 6.17715 14.9378 6.40673C15 6.66568 15 6.94084 15 7.49117Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  heightFill: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.5 5.5L9 3M9 15L11.5 12.5M9 15L6.5 12.5M9 15V3M9 3L11.5 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  heightFixed: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12.5 3H5.5M12.5 15H5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <line x1="9" y1="3.75" x2="9" y2="14.25" stroke="currentColor" stroke-width="1.5"/>
    </svg>`,
  heightHug: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.25 15L9 11.25L12.75 15M5.25 3L9 6.75L12.75 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  heightMax: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 13.5V4.5M9 13.5L6.75 12M9 13.5L11.25 12M9 4.5L6.75 6M9 4.5L11.25 6M15.75 2.25H2.25M15.75 15.75H2.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  heightMin: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.25 9H15.75M9 1.5V6.375M9 6.375L12 3.375M9 6.375L6 3.375M9 16.5V11.625M9 11.625L12 14.625M9 11.625L6 14.625" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  help: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.8175 6.75C6.99382 6.24875 7.34186 5.82608 7.8 5.55685C8.2581 5.28762 8.79667 5.1892 9.3204 5.27903C9.84412 5.36887 10.3191 5.64114 10.6613 6.04765C11.0035 6.45415 11.1908 6.96864 11.19 7.5C11.19 9 8.94 9.75 8.94 9.75M9 12.75H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  horizontalBottom: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.5 15V7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M9 15V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M13.5 15V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  horizontalCenter: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.5 12.75V5.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M9 15V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M13.5 11.25V6.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  horizontalTop: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.5 10.5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M9 15V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M13.5 7.5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  imageIndentLeft: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.75 6.9375H11.25M15.75 3H2.25M15.75 11.0625H11.25M15.75 15H2.25M3.45 12H7.05C7.47004 12 7.68008 12 7.8405 11.9182C7.98165 11.8463 8.09632 11.7317 8.16825 11.5905C8.25 11.4301 8.25 11.2201 8.25 10.8V7.2C8.25 6.77996 8.25 6.56994 8.16825 6.40951C8.09632 6.26839 7.98165 6.15365 7.8405 6.08174C7.68008 6 7.47004 6 7.05 6H3.45C3.02996 6 2.81994 6 2.65951 6.08174C2.51839 6.15365 2.40365 6.26839 2.33174 6.40951C2.25 6.56994 2.25 6.77996 2.25 7.2V10.8C2.25 11.2201 2.25 11.4301 2.33174 11.5905C2.40365 11.7317 2.51839 11.8463 2.65951 11.9182C2.81994 12 3.02996 12 3.45 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  info: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 12V9M9 6H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  plus: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 3.75V14.25M3.75 9H14.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  redo: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.75 6.75H5.625C3.76104 6.75 2.25 8.26103 2.25 10.125C2.25 11.989 3.76104 13.5 5.625 13.5H9M15.75 6.75L12.75 3.75M15.75 6.75L12.75 9.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  refresh: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M16.5 7.5C16.5 7.5 14.9963 5.45116 13.7747 4.22868C12.553 3.0062 10.8648 2.25 9 2.25C5.27208 2.25 2.25 5.27208 2.25 9C2.25 12.728 5.27208 15.75 9 15.75C12.0773 15.75 14.6737 13.6907 15.4862 10.875M16.5 7.5V3M16.5 7.5H12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  search: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.75 15.75L11.2501 11.25M12.75 7.5C12.75 10.3995 10.3995 12.75 7.5 12.75C4.60051 12.75 2.25 10.3995 2.25 7.5C2.25 4.60051 4.60051 2.25 7.5 2.25C10.3995 2.25 12.75 4.60051 12.75 7.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  share: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15.75 6.75001V2.25001M15.75 2.25001H11.25M15.75 2.25001L9 9M7.5 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V12.15C2.25 13.4102 2.25 14.0401 2.49524 14.5215C2.71095 14.9449 3.05516 15.2891 3.47852 15.5048C3.95982 15.75 4.58988 15.75 5.85 15.75H12.15C13.4102 15.75 14.0401 15.75 14.5215 15.5048C14.9449 15.2891 15.2891 14.9449 15.5048 14.5215C15.75 14.0401 15.75 13.4102 15.75 12.15V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  spacingHeight: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 13.5V4.5M9 13.5L6.75 12M9 13.5L11.25 12M9 4.5L6.75 6M9 4.5L11.25 6M15.75 2.25H2.25M15.75 15.75H2.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  spacingWidth: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.5 9H13.5M4.5 9L6 6.75M4.5 9L6 11.25M13.5 9L12 6.75M13.5 9L12 11.25M15.75 15.75V2.25M2.25 15.75V2.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  switchOn: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M1.5 9C1.5 6.51472 3.51472 4.5 6 4.5H12C14.4853 4.5 16.5 6.51472 16.5 9C16.5 11.4853 14.4853 13.5 12 13.5H6C3.51472 13.5 1.5 11.4853 1.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12 11.5C13.3807 11.5 14.5 10.3807 14.5 9C14.5 7.6193 13.3807 6.5 12 6.5C10.6193 6.5 9.5 7.6193 9.5 9C9.5 10.3807 10.6193 11.5 12 11.5Z" fill="currentColor"/>
    </svg>`,
  switchOff: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M1.5 9C1.5 6.51472 3.51472 4.5 6 4.5H12C14.4853 4.5 16.5 6.51472 16.5 9C16.5 11.4853 14.4853 13.5 12 13.5H6C3.51472 13.5 1.5 11.4853 1.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M6 11.5C7.38071 11.5 8.5 10.3807 8.5 9C8.5 7.6193 7.38071 6.5 6 6.5C4.61929 6.5 3.5 7.6193 3.5 9C3.5 10.3807 4.61929 11.5 6 11.5Z" fill="currentColor"/>
    </svg>`,
  terminal: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3 12.75L7.5 8.25L3 3.75M9 14.25H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  trash: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.75 2.25H11.25M2.25 4.5H15.75M14.25 4.5L13.724 12.3895C13.6451 13.5731 13.6057 14.165 13.35 14.6138C13.1249 15.0089 12.7854 15.3265 12.3763 15.5248C11.9115 15.75 11.3183 15.75 10.132 15.75H7.86802C6.68168 15.75 6.08852 15.75 5.62376 15.5248C5.21457 15.3265 4.87507 15.0089 4.64998 14.6138C4.39433 14.165 4.35488 13.5731 4.27597 12.3895L3.75 4.5M7.5 7.875V11.625M10.5 7.875V11.625" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  undo: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.25 6.75H12.375C14.239 6.75 15.75 8.26103 15.75 10.125C15.75 11.989 14.239 13.5 12.375 13.5H9M2.25 6.75L5.25 3.75M2.25 6.75L5.25 9.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  userLeft: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14.25 15.75L12 13.5M12 13.5L14.25 11.25M12 13.5H16.5M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  userRight: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14.25 15.75L16.5 13.5M16.5 13.5L14.25 11.25M16.5 13.5H12M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  userUp: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 13.5L14.25 11.25M14.25 11.25L16.5 13.5M14.25 11.25V15.75M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  verticalCenter: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12.75 4.5L5.25 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3 9L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M6.75 13.5H11.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  verticalEnd: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15 4.5L7.5 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3 9L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M10.5 13.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  verticalStart: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M10.5 4.5L3 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3 9L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3 13.5H7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  warning: o`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.99985 6.74999V9.75M8.99985 12.75H9.00735M7.96133 2.91878L1.79264 13.5737C1.45049 14.1647 1.27941 14.4602 1.30469 14.7028C1.32675 14.9143 1.43758 15.1065 1.6096 15.2316C1.80681 15.375 2.14826 15.375 2.83115 15.375H15.1685C15.8514 15.375 16.1928 15.375 16.3901 15.2316C16.562 15.1065 16.6729 14.9143 16.6949 14.7028C16.7202 14.4602 16.5491 14.1647 16.207 13.5737L10.0383 2.91878C9.69743 2.3299 9.52695 2.03547 9.30458 1.93658C9.11055 1.85032 8.88908 1.85032 8.69513 1.93658C8.47268 2.03547 8.3022 2.32991 7.96133 2.91878Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  minus: o`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3.33333 8H12.6667" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
    </svg>`,
  dock: o`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6 12L10 8L6 4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
    </svg>`,
  edit: o`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        d="M12.0001 6.66667L9.33344 4.00001M1.66675 14.3333L3.92299 14.0827C4.19865 14.052 4.33648 14.0367 4.46531 13.995C4.57961 13.958 4.68838 13.9057 4.78867 13.8396C4.90171 13.765 4.99977 13.667 5.1959 13.4709L14.0001 4.66667C14.7365 3.93029 14.7365 2.73639 14.0001 2.00001C13.2637 1.26363 12.0698 1.26363 11.3334 2.00001L2.52923 10.8042C2.33311 11.0003 2.23505 11.0983 2.16051 11.2114C2.09437 11.3117 2.04209 11.4205 2.00509 11.5348C1.96339 11.6636 1.94807 11.8014 1.91744 12.0771L1.66675 14.3333Z"
        stroke="currentColor"
        stroke-linecap="round"
        stroke-linejoin="round" />
    </svg>`,
  editAlt: o`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_171_17)">
        <path
          d="M7.33325 2.66665H4.53325C3.41315 2.66665 2.85309 2.66665 2.42527 2.88464C2.04895 3.07639 1.74299 3.38235 1.55124 3.75867C1.33325 4.1865 1.33325 4.74655 1.33325 5.86665V11.4667C1.33325 12.5867 1.33325 13.1468 1.55124 13.5747C1.74299 13.9509 2.04895 14.2569 2.42527 14.4487C2.85309 14.6667 3.41315 14.6667 4.53325 14.6667H10.1333C11.2534 14.6667 11.8134 14.6667 12.2413 14.4487C12.6176 14.2569 12.9235 13.9509 13.1153 13.5747C13.3333 13.1468 13.3333 12.5867 13.3333 11.4667V8.66667M5.33323 10.6667H6.4496C6.77572 10.6667 6.93879 10.6667 7.09225 10.6298C7.22825 10.5971 7.35832 10.5433 7.47765 10.4702C7.61219 10.3877 7.72752 10.2724 7.95812 10.0418L14.3333 3.66665C14.8855 3.11437 14.8855 2.21894 14.3333 1.66665C13.781 1.11437 12.8855 1.11437 12.3333 1.66665L5.95807 8.0418C5.72747 8.2724 5.61217 8.38773 5.52971 8.52227C5.45661 8.6416 5.40274 8.7716 5.37007 8.90767C5.33323 9.06113 5.33323 9.2242 5.33323 9.55033V10.6667Z"
          stroke="currentColor"
          stroke-linecap="round"
          stroke-linejoin="round" />
      </g>
      <defs>
        <clipPath id="clip0_171_17">
          <rect width="16" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>`,
  codeAlt: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M3.33341 12.3333C3.33341 12.6429 3.33341 12.7977 3.35053 12.9277C3.46868 13.8252 4.17489 14.5314 5.07236 14.6495C5.20233 14.6666 5.35713 14.6666 5.66675 14.6666H10.8001C11.9202 14.6666 12.4802 14.6666 12.9081 14.4486C13.2844 14.2569 13.5903 13.951 13.7821 13.5746C14.0001 13.1468 14.0001 12.5868 14.0001 11.4666V6.65879C14.0001 6.16961 14.0001 5.92503 13.9448 5.69485C13.8958 5.49078 13.815 5.29569 13.7053 5.11675C13.5817 4.91491 13.4087 4.74195 13.0628 4.39605L10.9373 2.27057C10.5914 1.92467 10.4185 1.75171 10.2167 1.62803C10.0377 1.51837 9.84261 1.43757 9.63855 1.38857C9.40835 1.33331 9.16375 1.33331 8.67461 1.33331H5.66675C5.35713 1.33331 5.20233 1.33331 5.07236 1.35043C4.17489 1.46858 3.46868 2.17479 3.35053 3.07226C3.33341 3.20223 3.33341 3.35703 3.33341 3.66665M6.00008 9.66665L7.66675 7.99998L6.00008 6.33331M3.33341 6.33331L1.66675 7.99998L3.33341 9.66665"
      stroke="currentColor"
      stroke-width="1"
      stroke-linecap="round"
      stroke-linejoin="round" />
    </svg>`,
  save: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M4.66667 2V4.26667C4.66667 4.64003 4.66667 4.82672 4.73933 4.96933C4.80325 5.09477 4.90523 5.19675 5.03067 5.26067C5.17328 5.33333 5.35997 5.33333 5.73333 5.33333H10.2667C10.6401 5.33333 10.8267 5.33333 10.9693 5.26067C11.0948 5.19675 11.1967 5.09477 11.2607 4.96933C11.3333 4.82672 11.3333 4.64003 11.3333 4.26667V2.66667M11.3333 14V9.73333C11.3333 9.35993 11.3333 9.17327 11.2607 9.03067C11.1967 8.9052 11.0948 8.80327 10.9693 8.73933C10.8267 8.66667 10.6401 8.66667 10.2667 8.66667H5.73333C5.35997 8.66667 5.17328 8.66667 5.03067 8.73933C4.90523 8.80327 4.80325 8.9052 4.73933 9.03067C4.66667 9.17327 4.66667 9.35993 4.66667 9.73333V14M14 6.21699V10.8C14 11.9201 14 12.4801 13.782 12.908C13.5903 13.2843 13.2843 13.5903 12.908 13.782C12.4801 14 11.9201 14 10.8 14H5.2C4.07989 14 3.51984 14 3.09202 13.782C2.71569 13.5903 2.40973 13.2843 2.21799 12.908C2 12.4801 2 11.9201 2 10.8V5.2C2 4.07989 2 3.51984 2.21799 3.09202C2.40973 2.71569 2.71569 2.40973 3.09202 2.21799C3.51984 2 4.07989 2 5.2 2H9.783C10.1091 2 10.2722 2 10.4257 2.03684C10.5617 2.0695 10.6917 2.12337 10.8111 2.19648C10.9456 2.27893 11.0609 2.39423 11.2915 2.62484L13.3751 4.70849C13.6057 4.9391 13.7211 5.0544 13.8035 5.18895C13.8766 5.30825 13.9305 5.43831 13.9631 5.57436C14 5.72781 14 5.89087 14 6.21699Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  github: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clip-path="url(#clip0_202_25)">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M7.97616 0C3.56555 0 0 3.59184 0 8.03543C0 11.5874 2.28457 14.5941 5.45388 15.6583C5.85012 15.7383 5.99527 15.4854 5.99527 15.2727C5.99527 15.0864 5.9822 14.4478 5.9822 13.7825C3.76343 14.2616 3.30139 12.8247 3.30139 12.8247C2.94482 11.8934 2.41649 11.654 2.41649 11.654C1.69029 11.1618 2.46939 11.1618 2.46939 11.1618C3.27494 11.215 3.69763 11.9866 3.69763 11.9866C4.41061 13.2104 5.55951 12.8647 6.02171 12.6518C6.08767 12.1329 6.2991 11.7737 6.52359 11.5742C4.75396 11.3879 2.89208 10.6962 2.89208 7.60963C2.89208 6.73159 3.20882 6.01322 3.71069 5.45453C3.63151 5.25502 3.35412 4.43004 3.79004 3.32588C3.79004 3.32588 4.46351 3.11298 5.98204 4.15069C6.63218 3.9748 7.30265 3.88532 7.97616 3.88457C8.64963 3.88457 9.33616 3.9778 9.97012 4.15069C11.4888 3.11298 12.1623 3.32588 12.1623 3.32588C12.5982 4.43004 12.3207 5.25502 12.2415 5.45453C12.7566 6.01322 13.0602 6.73159 13.0602 7.60963C13.0602 10.6962 11.1984 11.3745 9.41551 11.5742C9.70612 11.8269 9.9569 12.3058 9.9569 13.0642C9.9569 14.1417 9.94384 15.0065 9.94384 15.2725C9.94384 15.4854 10.0891 15.7383 10.4852 15.6584C13.6545 14.594 15.9391 11.5874 15.9391 8.03543C15.9522 3.59184 12.3736 0 7.97616 0Z" fill="currentColor" />
    </g>
    <defs>
      <clipPath id="clip0_202_25">
        <rect width="16" height="15.6735" fill="white" />
      </clipPath>
    </defs>
  </svg>
  `,
  play: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M3.33334 3.32634C3.33334 2.6789 3.33334 2.35518 3.46833 2.17674C3.58593 2.02128 3.76568 1.92508 3.96027 1.91346C4.18363 1.90012 4.45298 2.07969 4.99168 2.43882L12.0021 7.1124C12.4472 7.40914 12.6697 7.55754 12.7473 7.74454C12.8151 7.90807 12.8151 8.0918 12.7473 8.25534C12.6697 8.44234 12.4472 8.59067 12.0021 8.88747L4.99168 13.561C4.45298 13.9201 4.18363 14.0997 3.96027 14.0864C3.76568 14.0748 3.58593 13.9786 3.46833 13.8231C3.33334 13.6447 3.33334 13.3209 3.33334 12.6735V3.32634Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  loading: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M8 1.5V3.16667M8 12V14.6667M3.83333 8H1.5M14.1667 8H13.1667M12.3047 12.3047L11.8333 11.8333M12.4428 3.61053L11.5 4.55333M3.28105 12.7189L5.16667 10.8333M3.41912 3.47245L4.83333 4.88667" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  error: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clip-path="url(#clip0_216_291)">
      <path d="M8 5.33334V8.00001M14.6667 8.00001C14.6667 11.6819 11.6819 14.6667 8 14.6667C4.31809 14.6667 1.33333 11.6819 1.33333 8.00001C1.33333 4.31811 4.31809 1.33334 8 1.33334C11.6819 1.33334 14.6667 4.31811 14.6667 8.00001Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
      <circle cx="8" cy="10.67" r="0.5" fill="currentColor"/>
    </g>
    <defs>
      <clipPath id="clip0_216_291">
        <rect width="16" height="16" fill="white"/>
      </clipPath>
    </defs>
  </svg>
  `,
  overlay: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clip-path="url(#clip0_211_179)">
      <path d="M1.33325 3.46665C1.33325 2.71991 1.33325 2.34654 1.47858 2.06133C1.60641 1.81044 1.81038 1.60647 2.06127 1.47864C2.34648 1.33331 2.71985 1.33331 3.46659 1.33331H8.53325C9.27998 1.33331 9.65338 1.33331 9.93858 1.47864C10.1895 1.60647 10.3935 1.81044 10.5213 2.06133C10.6666 2.34654 10.6666 2.71991 10.6666 3.46665V8.53331C10.6666 9.28005 10.6666 9.65345 10.5213 9.93865C10.3935 10.1895 10.1895 10.3935 9.93858 10.5213C9.65338 10.6666 9.27998 10.6666 8.53325 10.6666H3.46659C2.71985 10.6666 2.34648 10.6666 2.06127 10.5213C1.81038 10.3935 1.60641 10.1895 1.47858 9.93865C1.33325 9.65345 1.33325 9.28005 1.33325 8.53331V3.46665Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
      <path d="M5.33325 7.46665C5.33325 6.71991 5.33325 6.34654 5.47858 6.06133C5.60641 5.81044 5.81038 5.60647 6.06127 5.47864C6.34648 5.33331 6.71985 5.33331 7.46659 5.33331H12.5333C13.28 5.33331 13.6534 5.33331 13.9386 5.47864C14.1895 5.60647 14.3935 5.81044 14.5213 6.06133C14.6666 6.34654 14.6666 6.71991 14.6666 7.46665V12.5333C14.6666 13.28 14.6666 13.6534 14.5213 13.9386C14.3935 14.1895 14.1895 14.3935 13.9386 14.5213C13.6534 14.6666 13.28 14.6666 12.5333 14.6666H7.46659C6.71985 14.6666 6.34648 14.6666 6.06127 14.5213C5.81038 14.3935 5.60641 14.1895 5.47858 13.9386C5.33325 13.6534 5.33325 13.28 5.33325 12.5333V7.46665Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
    </g>
    <defs>
      <clipPath id="clip0_211_179">
        <rect width="16" height="16" fill="white" />
      </clipPath>
    </defs>
  </svg>
  `,
  linkExternal: o`<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
 <path d="M21 9L21 3M21 3H15M21 3L13 11M10 5H7.8C6.11984 5 5.27976 5 4.63803 5.32698C4.07354 5.6146 3.6146 6.07354 3.32698 6.63803C3 7.27976 3 8.11984 3 9.8V16.2C3 17.8802 3 18.7202 3.32698 19.362C3.6146 19.9265 4.07354 20.3854 4.63803 20.673C5.27976 21 6.11984 21 7.8 21H14.2C15.8802 21 16.7202 21 17.362 20.673C17.9265 20.3854 18.3854 19.9265 18.673 19.362C19 18.7202 19 17.8802 19 16.2V14" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
 </svg>`,
  locked: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
  <path d="M11.3333 7.33333V5.33333C11.3333 3.49239 9.84093 2 8 2C6.15905 2 4.66667 3.49239 4.66667 5.33333C4.66667 5.33333 4.66667 6.55228 4.66667 7.33333" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
  <path d="M5.86667 14H10.1333C11.2535 14 11.8135 14 12.2413 13.782C12.6177 13.5903 12.9236 13.2843 13.1153 12.908C13.3333 12.4801 13.3333 11.9201 13.3333 10.8V10.5333C13.3333 9.41321 13.3333 8.85321 13.1153 8.42534C12.9236 8.04901 12.6177 7.74308 12.2413 7.55134C11.8135 7.33334 11.2535 7.33334 10.1333 7.33334H5.86667C4.74656 7.33334 4.18651 7.33334 3.75869 7.55134C3.38236 7.74308 3.0764 8.04901 2.88465 8.42534C2.66667 8.85321 2.66667 9.41321 2.66667 10.5333V10.8C2.66667 11.9201 2.66667 12.4801 2.88465 12.908C3.0764 13.2843 3.38236 13.5903 3.75869 13.782C4.18651 14 4.74656 14 5.86667 14Z" fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
</svg>`,
  unlocked: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
  <path d="M4.66666 7.33333V5.33333C4.66666 3.49239 6.15905 2 8 2C9.61266 2 10.9578 3.14517 11.2667 4.66667M5.86666 14H10.1333C11.2535 14 11.8135 14 12.2413 13.782C12.6177 13.5903 12.9236 13.2843 13.1153 12.908C13.3333 12.4801 13.3333 11.9201 13.3333 10.8V10.5333C13.3333 9.4132 13.3333 8.8532 13.1153 8.42533C12.9236 8.049 12.6177 7.74307 12.2413 7.55133C11.8135 7.33333 11.2535 7.33333 10.1333 7.33333H5.86666C4.74656 7.33333 4.1865 7.33333 3.75868 7.55133C3.38236 7.74307 3.0764 8.049 2.88465 8.42533C2.66666 8.8532 2.66666 9.4132 2.66666 10.5333V10.8C2.66666 11.9201 2.66666 12.4801 2.88465 12.908C3.0764 13.2843 3.38236 13.5903 3.75868 13.782C4.1865 14 4.74656 14 5.86666 14Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
</svg>`,
  rhombus: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.88562 9.88559C2.22559 9.22556 1.89557 8.89554 1.77193 8.515C1.66316 8.18026 1.66316 7.81968 1.77193 7.48494C1.89557 7.1044 2.22559 6.77438 2.88562 6.11435L6.18545 2.81452C6.8455 2.15447 7.17548 1.82449 7.55605 1.70082C7.89079 1.59205 8.25136 1.59207 8.58609 1.70084C8.96664 1.82448 9.29666 2.15449 9.95669 2.81452L13.2565 6.11435C13.9166 6.7744 14.2465 7.10438 14.3702 7.48496C14.479 7.8197 14.479 8.18024 14.3702 8.51498C14.2465 8.89556 13.9166 9.22554 13.2565 9.88559L9.95669 13.1854C9.29666 13.8454 8.96664 14.1755 8.58609 14.2991C8.25136 14.4079 7.89079 14.4079 7.55605 14.2991C7.17548 14.1754 6.8455 13.8455 6.18545 13.1854L2.88562 9.88559Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  thumbsUp: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.66667 14.6667V7.33334M1.33334 8.66668V13.3333C1.33334 14.0697 1.93029 14.6667 2.66667 14.6667H11.6175C12.6047 14.6667 13.4441 13.9465 13.5943 12.9708L14.3122 8.30414C14.4986 7.09261 13.5612 6.00001 12.3355 6.00001H10C9.6318 6.00001 9.33334 5.70153 9.33334 5.33334V2.97724C9.33334 2.06934 8.59734 1.33334 7.68947 1.33334C7.47287 1.33334 7.27667 1.46088 7.18874 1.65876L4.84263 6.93741C4.73563 7.17821 4.49688 7.33334 4.23342 7.33334H2.66667C1.93029 7.33334 1.33334 7.93028 1.33334 8.66668Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  thumbsUpFilled: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.66666 14.6667V7.33334ZM1.33333 8.66668V13.3333C1.33333 14.0697 1.93028 14.6667 2.66666 14.6667H11.6175C12.6047 14.6667 13.4441 13.9465 13.5943 12.9708L14.3122 8.30414C14.4986 7.09261 13.5612 6.00001 12.3355 6.00001H10C9.6318 6.00001 9.33333 5.70153 9.33333 5.33334V2.97724C9.33333 2.06934 8.59733 1.33334 7.68946 1.33334C7.47286 1.33334 7.27666 1.46088 7.18873 1.65876L4.84262 6.93741C4.73562 7.17821 4.49688 7.33334 4.23342 7.33334H2.66666C1.93028 7.33334 1.33333 7.93028 1.33333 8.66668Z" fill="currentColor"/>
<path d="M4.66666 14.6667V7.33334M1.33333 8.66668V13.3333C1.33333 14.0697 1.93028 14.6667 2.66666 14.6667H11.6175C12.6047 14.6667 13.4441 13.9465 13.5943 12.9708L14.3122 8.30414C14.4986 7.09261 13.5612 6.00001 12.3355 6.00001H10C9.6318 6.00001 9.33333 5.70153 9.33333 5.33334V2.97724C9.33333 2.06934 8.59733 1.33334 7.68946 1.33334C7.47286 1.33334 7.27666 1.46088 7.18873 1.65876L4.84262 6.93741C4.73562 7.17821 4.49688 7.33334 4.23342 7.33334H2.66666C1.93028 7.33334 1.33333 7.93028 1.33333 8.66668Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  thumbsDown: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.3334 1.33334V8.66668M14.6667 6.53334V3.46668C14.6667 2.71994 14.6667 2.34657 14.5214 2.06136C14.3935 1.81047 14.1896 1.6065 13.9387 1.47867C13.6535 1.33334 13.2801 1.33334 12.5334 1.33334H5.41204C4.43772 1.33334 3.95056 1.33334 3.55709 1.51163C3.2103 1.66877 2.91557 1.92162 2.70753 2.24049C2.47148 2.60227 2.39741 3.08377 2.24926 4.04676L1.90054 6.31342C1.70514 7.58354 1.60743 8.21861 1.79591 8.71274C1.96133 9.14648 2.27247 9.50914 2.67599 9.73861C3.13572 10 3.77826 10 5.06333 10H5.60004C5.97341 10 6.16009 10 6.3027 10.0727C6.42814 10.1366 6.53013 10.2385 6.59404 10.364C6.66674 10.5066 6.66674 10.6933 6.66674 11.0667V13.0228C6.66674 13.9307 7.40267 14.6667 8.3106 14.6667C8.52714 14.6667 8.7234 14.5391 8.81134 14.3413L11.0519 9.30014C11.1537 9.07081 11.2047 8.95621 11.2852 8.87214C11.3564 8.79781 11.4439 8.74101 11.5407 8.70614C11.6502 8.66668 11.7757 8.66668 12.0265 8.66668H12.5334C13.2801 8.66668 13.6535 8.66668 13.9387 8.52134C14.1896 8.39354 14.3935 8.18954 14.5214 7.93868C14.6667 7.65348 14.6667 7.28008 14.6667 6.53334Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  thumbsDownFilled: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.3334 1.33334V8.66668ZM14.6667 6.53334V3.46668C14.6667 2.71994 14.6667 2.34657 14.5214 2.06136C14.3935 1.81047 14.1896 1.6065 13.9387 1.47867C13.6535 1.33334 13.2801 1.33334 12.5334 1.33334H5.41204C4.43772 1.33334 3.95056 1.33334 3.55708 1.51163C3.2103 1.66877 2.91556 1.92162 2.70752 2.24049C2.47148 2.60227 2.3974 3.08377 2.24925 4.04676L1.90053 6.31342C1.70513 7.58354 1.60742 8.21861 1.7959 8.71274C1.96132 9.14648 2.27246 9.50914 2.67598 9.73861C3.13572 10 3.77826 10 5.06332 10H5.60003C5.9734 10 6.16008 10 6.30269 10.0727C6.42814 10.1366 6.53012 10.2385 6.59404 10.364C6.66673 10.5066 6.66673 10.6933 6.66673 11.0667V13.0228C6.66673 13.9307 7.40266 14.6667 8.3106 14.6667C8.52713 14.6667 8.7234 14.5391 8.81133 14.3413L11.0519 9.30014C11.1537 9.07081 11.2047 8.95621 11.2852 8.87214C11.3564 8.79781 11.4439 8.74101 11.5407 8.70614C11.6502 8.66668 11.7757 8.66668 12.0265 8.66668H12.5334C13.2801 8.66668 13.6535 8.66668 13.9387 8.52134C14.1896 8.39354 14.3935 8.18954 14.5214 7.93868C14.6667 7.65348 14.6667 7.28008 14.6667 6.53334Z" fill="currentColor"/>
<path d="M11.3334 1.33334V8.66668M14.6667 6.53334V3.46668C14.6667 2.71994 14.6667 2.34657 14.5214 2.06136C14.3935 1.81047 14.1896 1.6065 13.9387 1.47867C13.6535 1.33334 13.2801 1.33334 12.5334 1.33334H5.41204C4.43772 1.33334 3.95056 1.33334 3.55708 1.51163C3.2103 1.66877 2.91556 1.92162 2.70752 2.24049C2.47148 2.60227 2.3974 3.08377 2.24925 4.04676L1.90053 6.31342C1.70513 7.58354 1.60742 8.21861 1.7959 8.71274C1.96132 9.14648 2.27246 9.50914 2.67598 9.73861C3.13572 10 3.77826 10 5.06332 10H5.60003C5.9734 10 6.16008 10 6.30269 10.0727C6.42814 10.1366 6.53012 10.2385 6.59404 10.364C6.66673 10.5066 6.66673 10.6933 6.66673 11.0667V13.0228C6.66673 13.9307 7.40266 14.6667 8.3106 14.6667C8.52713 14.6667 8.7234 14.5391 8.81133 14.3413L11.0519 9.30014C11.1537 9.07081 11.2047 8.95621 11.2852 8.87214C11.3564 8.79781 11.4439 8.74101 11.5407 8.70614C11.6502 8.66668 11.7757 8.66668 12.0265 8.66668H12.5334C13.2801 8.66668 13.6535 8.66668 13.9387 8.52134C14.1896 8.39354 14.3935 8.18954 14.5214 7.93868C14.6667 7.65348 14.6667 7.28008 14.6667 6.53334Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  check: o`<svg width="100%" height="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
 <path d="M20 6L9 17L4 12" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
 </svg>`,
  vaadinLogo: o`
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M3 3C2.55 3 2.25 3.3 2.25 3.75V5.625C2.25 7.05 3.45 8.25 4.875 8.25H10.1997C10.7997 8.25 11.25 8.70029 11.25 9.30029V9.75C11.25 10.2 11.55 10.5 12 10.5C12.45 10.5 12.75 10.2 12.75 9.75V9.30029C12.75 8.70029 13.2003 8.25 13.8003 8.25H19.125C20.55 8.25 21.75 7.05 21.75 5.625V3.75C21.75 3.3 21.45 3 21 3C20.55 3 20.25 3.3 20.25 3.75V4.19971C20.25 4.79971 19.7997 5.25 19.1997 5.25H14.25C12.975 5.25 12 6.225 12 7.5C12 6.225 11.025 5.25 9.75 5.25H4.80029C4.20029 5.25 3.75 4.79971 3.75 4.19971V3.75C3.75 3.3 3.45 3 3 3ZM7.76367 11.2705C7.62187 11.2834 7.48184 11.3244 7.35059 11.3994C6.82559 11.6994 6.59941 12.3744 6.89941 12.8994L11.0244 20.3994C11.1744 20.7744 11.625 21 12 21C12.375 21 12.8256 20.7744 12.9756 20.3994L17.1006 12.8994C17.4006 12.3744 17.1744 11.6994 16.6494 11.3994C16.1244 11.0994 15.4494 11.3256 15.1494 11.8506L12 17.5503L8.85059 11.8506C8.62559 11.4568 8.18906 11.2318 7.76367 11.2705Z" fill="currentColor"/>
    </svg>`,
  cancel: o`
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    <path d="M8 9.6C8 9.03995 8 8.75992 8.10899 8.54601C8.20487 8.35785 8.35785 8.20487 8.54601 8.10899C8.75992 8 9.03995 8 9.6 8H14.4C14.9601 8 15.2401 8 15.454 8.10899C15.6422 8.20487 15.7951 8.35785 15.891 8.54601C16 8.75992 16 9.03995 16 9.6V14.4C16 14.9601 16 15.2401 15.891 15.454C15.7951 15.6422 15.6422 15.7951 15.454 15.891C15.2401 16 14.9601 16 14.4 16H9.6C9.03995 16 8.75992 16 8.54601 15.891C8.35785 15.7951 8.20487 15.6422 8.10899 15.454C8 15.2401 8 14.9601 8 14.4V9.6Z" fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  x: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M11.3333 4.66666L4.66667 11.3333M4.66667 4.66666L11.3333 11.3333" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>`,
  rotatingSpinner: o`
  <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    <path d="M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,19a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" opacity=".25" fill="currentColor"/>
    <path fill="currentColor" d="M10.14,1.16a11,11,0,0,0-9,8.92A1.59,1.59,0,0,0,2.46,12,1.52,1.52,0,0,0,4.11,10.7a8,8,0,0,1,6.66-6.61A1.42,1.42,0,0,0,12,2.69h0A1.57,1.57,0,0,0,10.14,1.16Z">
    <animateTransform attributeName="transform" type="rotate" dur="0.75s" values="0 12 12;360 12 12" repeatCount="indefinite"/>
    </path>
   </svg>
  `,
  dockLeft: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M6 2V14M5.2 2H10.8C11.9201 2 12.4801 2 12.908 2.21799C13.2843 2.40973 13.5903 2.71569 13.782 3.09202C14 3.51984 14 4.07989 14 5.2V10.8C14 11.9201 14 12.4801 13.782 12.908C13.5903 13.2843 13.2843 13.5903 12.908 13.782C12.4801 14 11.9201 14 10.8 14H5.2C4.07989 14 3.51984 14 3.09202 13.782C2.71569 13.5903 2.40973 13.2843 2.21799 12.908C2 12.4801 2 11.9201 2 10.8V5.2C2 4.07989 2 3.51984 2.21799 3.09202C2.40973 2.71569 2.71569 2.40973 3.09202 2.21799C3.51984 2 4.07989 2 5.2 2Z" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  dockBottom: o`
  <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
   <path d="M3 15H21M7.8 3H16.2C17.8802 3 18.7202 3 19.362 3.32698C19.9265 3.6146 20.3854 4.07354 20.673 4.63803C21 5.27976 21 6.11984 21 7.8V16.2C21 17.8802 21 18.7202 20.673 19.362C20.3854 19.9265 19.9265 20.3854 19.362 20.673C18.7202 21 17.8802 21 16.2 21H7.8C6.11984 21 5.27976 21 4.63803 20.673C4.07354 20.3854 3.6146 19.9265 3.32698 19.362C3 18.7202 3 17.8802 3 16.2V7.8C3 6.11984 3 5.27976 3.32698 4.63803C3.6146 4.07354 4.07354 3.6146 4.63803 3.32698C5.27976 3 6.11984 3 7.8 3Z" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  dockRight: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M10 2V14M5.2 2H10.8C11.9201 2 12.4801 2 12.908 2.21799C13.2843 2.40973 13.5903 2.71569 13.782 3.09202C14 3.51984 14 4.07989 14 5.2V10.8C14 11.9201 14 12.4801 13.782 12.908C13.5903 13.2843 13.2843 13.5903 12.908 13.782C12.4801 14 11.9201 14 10.8 14H5.2C4.07989 14 3.51984 14 3.09202 13.782C2.71569 13.5903 2.40973 13.2843 2.21799 12.908C2 12.4801 2 11.9201 2 10.8V5.2C2 4.07989 2 3.51984 2.21799 3.09202C2.40973 2.71569 2.71569 2.40973 3.09202 2.21799C3.51984 2 4.07989 2 5.2 2Z" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>

  `,
  tabOrder: o`<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 14V2M2 8H11.3333M11.3333 8L6.66667 3.33333M11.3333 8L6.66667 12.6667" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  padding: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 2H4M12 14H4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
    <path d="M14 12V4M2 12V4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>`,
  paddingTop: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 2H4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
  </svg>
  `,
  paddingRight: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
    <path d="M14 12V4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  paddingBottom: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 14H4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
  </svg>
  `,
  paddingLeft: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
    <path d="M2 12V4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  paddingVertical: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 2H4M12 14H4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
  </svg>
  `,
  paddingHorizontal: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="5.5" y="5.5" width="5" height="5" rx="1.5" stroke="currentColor"/>
    <path d="M14 12V4M2 12V4" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  maximize: o`
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M5.33333 2H5.2C4.07989 2 3.51984 2 3.09202 2.21799C2.71569 2.40973 2.40973 2.71569 2.21799 3.09202C2 3.51984 2 4.07989 2 5.2V5.33333M5.33333 14H5.2C4.07989 14 3.51984 14 3.09202 13.782C2.71569 13.5903 2.40973 13.2843 2.21799 12.908C2 12.4801 2 11.9201 2 10.8V10.6667M14 5.33333V5.2C14 4.07989 14 3.51984 13.782 3.09202C13.5903 2.71569 13.2843 2.40973 12.908 2.21799C12.4801 2 11.9201 2 10.8 2H10.6667M14 10.6667V10.8C14 11.9201 14 12.4801 13.782 12.908C13.5903 13.2843 13.2843 13.5903 12.908 13.782C12.4801 14 11.9201 14 10.8 14H10.6667" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  warningColorful: o`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 5L4 19H20L12 5ZM12 17C11.4 17 11 16.6 11 16C11 15.4 11.4 15 12 15C12.6 15 13 15.4 13 16C13 16.6 12.6 17 12 17ZM11 14V10H13V14H11Z" fill="#FFCC00"/>
</svg>`,
  successColorful: o`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 4C7.6 4 4 7.6 4 12C4 16.4 7.6 20 12 20C16.4 20 20 16.4 20 12C20 7.6 16.4 4 12 4ZM11.1 15.7L6.9 11.6L8.3 10.2L11 12.9L16 8L17.4 9.4L11.1 15.7Z" fill="#27AE60"/>
</svg>`,
  flow: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M16.4251 9.33334C13.4602 11.5926 8.46833 9.90501 6.6915 7.57429C4.00813 4.06026 -1.08616 8.24395 2.18637 11.7714C6.41908 16.187 13.9558 14.6823 16.4251 9.33334Z" fill="#00B4F0"/>
    <path d="M2.18317 11.7758C6.42021 16.1869 13.9613 14.6823 16.4259 9.33772C18.8593 3.93075 10.6841 1.1179 9.10795 6.62782C8.89088 7.42258 8.53415 8.17233 8.05445 8.84216C6.75068 10.6593 4.60751 11.7758 2.18317 11.7758Z" fill="#FF707A"/>
    <path d="M16.4259 9.33333C14.0418 11.1551 10.3359 10.4139 8.05445 8.83777C6.75068 10.6595 4.60751 11.7758 2.18317 11.7711C3.90197 13.5616 6.1703 14.3786 8.42052 14.3565C11.7068 14.3296 14.9614 12.5125 16.4259 9.33333Z" fill="#5748FF"/>
  </svg>
  `,
  hilla: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<mask id="mask0_1810_437" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="1" y="1" width="16" height="16">
<path d="M16.875 1.6875H1.125V16.3125H16.875V1.6875Z" fill="white"/>
</mask>
<g mask="url(#mask0_1810_437)">
<mask id="mask1_1810_437" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="1" y="1" width="16" height="16">
<path d="M16.7644 8.20405C16.469 7.03427 15.4391 6.11683 14.2563 5.94628C15.464 2.60481 11.2299 0.180846 8.99083 2.89325C6.74837 0.178915 2.51524 2.60915 3.72629 5.94769C0.259345 6.55457 0.256463 11.4556 3.72629 12.062C3.04942 13.7468 4.0395 15.7242 5.79195 16.1755C6.93816 16.5046 8.26014 16.0625 8.98937 15.1189C9.53702 15.8344 10.5012 16.2963 11.386 16.2785C13.5031 16.306 15.0634 14.0791 14.2539 12.0581C16.0136 11.8243 17.2631 9.96124 16.7644 8.20405ZM9.88239 10.4942C9.86029 10.5077 9.83773 10.5207 9.81518 10.5332C9.33238 10.8111 8.65119 10.8111 8.1684 10.5332C8.14629 10.5197 8.12374 10.5067 8.10113 10.4942H8.09685C7.84974 10.3434 7.64404 10.1329 7.49858 9.88176C7.35306 9.6306 7.27239 9.34682 7.26384 9.05629C7.26384 9.02248 7.26384 8.98868 7.26384 8.95532C7.27723 8.50302 7.46533 8.07377 7.78821 7.75872C8.11108 7.44366 8.54336 7.26748 8.99325 7.26765C10.749 7.28554 11.3649 9.58678 9.88914 10.4942H9.88239ZM6.58794 3.08119C6.86784 3.08139 7.14347 3.14989 7.39125 3.28084C7.63898 3.41178 7.85143 3.60126 8.01039 3.83298C8.12104 3.9903 8.26796 4.11835 8.43851 4.20617C8.60906 4.29401 8.79823 4.33903 8.98988 4.33738C9.18501 4.33729 9.37721 4.2896 9.55001 4.19837C9.72276 4.10716 9.87098 3.97514 9.98184 3.81365C10.8677 2.52509 13.0784 3.01162 13.1221 4.82053C13.1221 5.11783 13.0462 5.41015 12.9017 5.66959C12.7574 5.92896 12.5493 6.14687 12.2973 6.30235C11.5023 6.80578 10.4718 6.52892 9.97222 5.811C9.86113 5.65317 9.71387 5.52464 9.54287 5.43632C9.37181 5.348 9.18214 5.3025 8.98988 5.30368C8.79896 5.30205 8.61053 5.34701 8.44065 5.4347C8.27083 5.52238 8.12469 5.65018 8.01467 5.80712C7.42714 6.66522 6.12051 6.85315 5.34134 6.02503C4.29315 4.94132 5.07041 3.07684 6.58794 3.08119ZM8.24816 13.6718C7.9263 14.8347 6.49283 15.3174 5.53445 14.5695C4.87152 14.0675 4.68707 13.1481 5.02958 12.4306C5.10884 12.2627 5.14627 12.0778 5.13866 11.892C5.13105 11.7063 5.0786 11.5252 4.98586 11.3643L4.95174 11.3054C4.85772 11.1447 4.72643 11.0092 4.56909 10.9106C4.41174 10.812 4.233 10.7532 4.04814 10.7391C3.49378 10.6908 2.96295 10.3715 2.68817 9.87428C1.92532 8.55381 3.14358 6.94399 4.60011 7.31693C5.70499 7.58608 6.19644 8.81475 5.74678 9.7588C5.66691 9.93149 5.63001 10.1212 5.63929 10.3114C5.64862 10.5016 5.70381 10.6867 5.80011 10.8507L5.81017 10.8681C5.90569 11.0337 6.03956 11.1736 6.20038 11.2759C6.36126 11.3782 6.54429 11.4398 6.73397 11.4556C6.99024 11.4775 7.23853 11.5564 7.46083 11.6866C8.13381 12.0644 8.47586 12.9355 8.24912 13.6718H8.24816ZM15.2916 9.87428C15.1513 10.1186 14.9539 10.3248 14.7167 10.4754C14.4794 10.6258 14.2093 10.716 13.9297 10.7381C13.7469 10.7505 13.57 10.8076 13.4141 10.9042C13.2581 11.0009 13.1279 11.1342 13.0347 11.2928L12.99 11.3706C12.8968 11.5299 12.8441 11.7098 12.8367 11.8946C12.8293 12.0792 12.8675 12.2629 12.9478 12.4292C13.6559 13.8515 12.1201 15.5696 10.5271 14.6951C9.37755 14.0308 9.38379 12.347 10.5189 11.6866C10.7464 11.5538 11.0008 11.4745 11.263 11.4546C11.4474 11.44 11.6255 11.3804 11.7818 11.281C11.9382 11.1815 12.0682 11.0453 12.1604 10.8841L12.1979 10.8188C12.2889 10.6564 12.3396 10.4742 12.3452 10.2878C12.3509 10.1014 12.3116 9.91641 12.2305 9.74867C11.8659 8.96741 12.1253 7.96678 12.9132 7.50638C13.0588 7.4202 13.2161 7.35591 13.3801 7.31552C14.8559 6.95074 16.0516 8.54852 15.2925 9.87428H15.2916Z" fill="url(#paint0_linear_1810_437)"/>
</mask>
<g mask="url(#mask1_1810_437)">
<path d="M-20.3607 4.60958L16.8058 -17.6493L26.578 -1.33227L-10.5885 20.9266L-20.3607 4.60958Z" fill="#FF707A"/>
<path d="M-20.3607 4.60958L16.8058 -17.6493L26.578 -1.33227L-10.5885 20.9266L-20.3607 4.60958Z" fill="#FF707A"/>
<path d="M-12.2592 21.8684L24.9073 -0.390442L34.6795 15.9266L-2.48704 38.1855L-12.2592 21.8684Z" fill="#FF707A"/>
<path d="M-12.2592 21.8684L24.9073 -0.390442L34.6795 15.9266L-2.48704 38.1855L-12.2592 21.8684Z" fill="#00B4F0"/>
</g>
</g>
<defs>
<linearGradient id="paint0_linear_1810_437" x1="18.2954" y1="12.9077" x2="-3.45376" y2="-0.300254" gradientUnits="userSpaceOnUse">
<stop stop-color="#FF707A"/>
<stop offset="0.467045" stop-color="#5748FF"/>
<stop offset="1" stop-color="#00B4F0"/>
</linearGradient>
</defs>
</svg>
  `,
  square: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M2.25 5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  globe: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clip-path="url(#clip0_1810_1059)">
    <path d="M9 1.5C10.876 3.55376 11.9421 6.21902 12 9C11.9421 11.781 10.876 14.4462 9 16.5M9 1.5C7.12404 3.55376 6.05794 6.21902 6 9C6.05794 11.781 7.12404 14.4462 9 16.5M9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5M9 1.5C13.1421 1.5 16.5 4.85786 16.5 9C16.5 13.1421 13.1421 16.5 9 16.5M1.87501 6.75H16.125M1.875 11.25H16.125" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </g>
    <defs>
    <clipPath id="clip0_1810_1059">
    <rect width="18" height="18" fill="currentColor"/>
    </clipPath>
    </defs>
  </svg>
  `,
  dashboard: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
  <path d="M9.75 6.75V2.25H15.75V6.75H9.75ZM2.25 9.75V2.25H8.25V9.75H2.25ZM9.75 15.75V8.25H15.75V15.75H9.75ZM2.25 15.75V11.25H8.25V15.75H2.25ZM3.75 8.25H6.75V3.75H3.75V8.25ZM11.25 14.25H14.25V9.75H11.25V14.25ZM11.25 5.25H14.25V3.75H11.25V5.25ZM3.75 14.25H6.75V12.75H3.75V14.25Z" fill="currentColor" fill-opacity="0.87"/>
</svg>
  `,
  feed: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M15.75 9H6.75M15.75 4.5H6.75M15.75 13.5H6.75M3.75 9C3.75 9.41423 3.41421 9.75 3 9.75C2.58579 9.75 2.25 9.41423 2.25 9C2.25 8.58578 2.58579 8.25 3 8.25C3.41421 8.25 3.75 8.58578 3.75 9ZM3.75 4.5C3.75 4.91421 3.41421 5.25 3 5.25C2.58579 5.25 2.25 4.91421 2.25 4.5C2.25 4.08579 2.58579 3.75 3 3.75C3.41421 3.75 3.75 4.08579 3.75 4.5ZM3.75 13.5C3.75 13.9142 3.41421 14.25 3 14.25C2.58579 14.25 2.25 13.9142 2.25 13.5C2.25 13.0858 2.58579 12.75 3 12.75C3.41421 12.75 3.75 13.0858 3.75 13.5Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  markerPin: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M9 9.75C10.2427 9.75 11.25 8.74268 11.25 7.5C11.25 6.25736 10.2427 5.25 9 5.25C7.75732 5.25 6.75 6.25736 6.75 7.5C6.75 8.74268 7.75732 9.75 9 9.75Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    <path d="M9 16.5C12 13.5 15 10.8137 15 7.5C15 4.18629 12.3137 1.5 9 1.5C5.68629 1.5 3 4.18629 3 7.5C3 10.8137 6 13.5 9 16.5Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  creditCard: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M16.5 7.5H1.5M1.5 6.15V11.85C1.5 12.6901 1.5 13.1102 1.66349 13.431C1.8073 13.7132 2.03677 13.9427 2.31901 14.0865C2.63988 14.25 3.05992 14.25 3.9 14.25H14.1C14.9401 14.25 15.3601 14.25 15.681 14.0865C15.9632 13.9427 16.1927 13.7132 16.3365 13.431C16.5 13.1102 16.5 12.6901 16.5 11.85V6.15C16.5 5.30993 16.5 4.88988 16.3365 4.56902C16.1927 4.28678 15.9632 4.0573 15.681 3.91349C15.3601 3.75 14.9401 3.75 14.1 3.75H3.9C3.05992 3.75 2.63988 3.75 2.31901 3.91349C2.03677 4.0573 1.8073 4.28677 1.66349 4.56902C1.5 4.88988 1.5 5.30992 1.5 6.15Z" stroke="black" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  user: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 15.75C15 14.7033 15 14.18 14.8708 13.7542C14.58 12.7954 13.8296 12.045 12.8708 11.7542C12.445 11.625 11.9217 11.625 10.875 11.625H7.125C6.07833 11.625 5.55499 11.625 5.12914 11.7542C4.17034 12.045 3.42003 12.7954 3.12918 13.7542C3 14.18 3 14.7033 3 15.75M12.375 5.625C12.375 7.48896 10.864 9 9 9C7.13604 9 5.625 7.48896 5.625 5.625C5.625 3.76104 7.13604 2.25 9 2.25C10.864 2.25 12.375 3.76104 12.375 5.625Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
  `,
  table: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M2.25 6.75H15.75M6.75 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  columns: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M9 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z" stroke="black" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  map: o`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clip-path="url(#clip0_1810_1110)">
    <path d="M6.75 13.5L1.5 16.5V4.5L6.75 1.5M6.75 13.5L12 16.5M6.75 13.5V1.5M6.75 1.5L12 4.5M12 16.5L16.5 13.5V1.5L12 4.5M12 16.5V4.5" stroke="currentColor" stroke-opacity="0.87" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </g>
    <defs>
    <clipPath id="clip0_1810_1110">
    <rect width="18" height="18" fill="white"/>
    </clipPath>
    </defs>
  </svg>

  `
};
export {
  e as i
};
