/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.AccessRequirement;
import com.vaadin.copilot.AccessRequirementUtil;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.FlowUtil;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.RouteCreator;
import com.vaadin.copilot.RouteDuplicatedException;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    private final VaadinServletContext context;
    private final RouteCreator routeCreator;

    public RouteHandler(ProjectManager projectManager, VaadinServletContext context) {
        this.projectManager = projectManager;
        this.context = context;
        this.routeCreator = new RouteCreator(projectManager);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-routes")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            boolean securityEnabled = this.isViewSecurityEnabled();
            returnData.put("securityEnabled", securityEnabled);
            if (SpringBridge.isSpringAvailable()) {
                returnData.put("urlPrefix", SpringBridge.getUrlPrefix(this.context));
            }
            returnData.put("supportsHilla", EndpointRequestUtil.isHillaAvailable());
            VaadinSession vaadinSession = this.projectManager.getVaadinSession();
            try {
                JsonArray serverRoutes = (JsonArray)RouteHandler.getServerRoutes(vaadinSession).stream().map(routeData -> {
                    JsonObject route = Json.createObject();
                    Class target = routeData.getNavigationTarget();
                    route.put("path", this.addInitialSlash(routeData.getTemplate()));
                    route.put("navigationTarget", target.getName());
                    if (securityEnabled) {
                        try {
                            AccessRequirement req = AccessRequirementUtil.getAccessRequirement(target, null);
                            route.put("accessRequirement", (JsonValue)JsonUtils.beanToJson((Object)req));
                        }
                        catch (Exception e) {
                            RouteHandler.getLogger().error("Unable to determine access requirement", (Throwable)e);
                        }
                    }
                    route.put("filename", this.projectManager.getFileForClass(routeData.getNavigationTarget()).getAbsolutePath());
                    return route;
                }).collect(JsonUtils.asArray());
                returnData.put("routes", (JsonValue)serverRoutes);
                devToolsInterface.send("server-routes", returnData);
            }
            catch (Exception e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Error getting routes", e);
            }
            return true;
        }
        if (command.equals("add-route")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            String route = data.getString("route");
            if (route.startsWith("/")) {
                route = route.substring(1);
            }
            String framework = data.getString("framework");
            AccessRequirement.Type accessControl = AccessRequirement.Type.valueOf(data.getString("accesscontrol"));
            AccessRequirement accessRequirement = accessControl == AccessRequirement.Type.ROLES_ALLOWED ? new AccessRequirement(accessControl, (String[])JsonUtils.stream((JsonArray)data.getArray("roles")).map(JsonValue::asString).toArray(String[]::new)) : new AccessRequirement(accessControl);
            try {
                if ("hilla".equals(framework)) {
                    this.routeCreator.createHillaView(route, accessRequirement);
                } else if ("flow".equals(framework)) {
                    List<Class<? extends HasElement>> viewChain;
                    Class<? extends HasElement> layoutClass = null;
                    if (data.hasKey("uiId") && (viewChain = FlowUtil.getViewChain(this.projectManager.getVaadinSession(), (int)data.getNumber("uiId"))).size() > 1) {
                        layoutClass = viewChain.get(1);
                    }
                    this.routeCreator.createFlowView(route, accessRequirement, layoutClass);
                } else {
                    throw new IllegalArgumentException("Unknown framework: " + framework);
                }
                devToolsInterface.send(command + "-response", returnData);
            }
            catch (RouteDuplicatedException e) {
                returnData.put("errorDuplicatedRoute", true);
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Route already exists", e);
            }
            catch (Exception e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Error adding route", e);
            }
            return true;
        }
        return false;
    }

    private boolean isViewSecurityEnabled() {
        return SpringBridge.isSpringAvailable() && SpringBridge.isViewSecurityEnabled(this.context);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RouteHandler.class);
    }

    private String addInitialSlash(String template) {
        if (!template.startsWith("/")) {
            return "/" + template;
        }
        return template;
    }

    public static List<RouteData> getServerRoutes(VaadinSession vaadinSession) {
        try {
            vaadinSession.lock();
            List list = vaadinSession.getService().getRouter().getRegistry().getRegisteredRoutes();
            return list;
        }
        catch (Exception e) {
            RouteHandler.getLogger().error("Error getting server routes", (Throwable)e);
        }
        finally {
            vaadinSession.unlock();
        }
        return null;
    }
}

