/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.JavaSourcePathDetector;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileManager {
    private static ProjectFileManager instance = null;
    private final ApplicationConfiguration applicationConfiguration;
    private JavaSourcePathDetector.ProjectPaths projectPaths0 = null;

    public static synchronized ProjectFileManager initialize(ApplicationConfiguration applicationConfiguration) {
        if (instance == null || ProjectFileManager.instance.applicationConfiguration != applicationConfiguration) {
            instance = new ProjectFileManager(applicationConfiguration);
        }
        return instance;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ProjectFileManager.class);
    }

    public static ProjectFileManager getInstance() {
        return instance;
    }

    ProjectFileManager(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public String readFile(String filename) throws IOException {
        return this.readFile(new File(filename));
    }

    public String readFile(Path filename) throws IOException {
        return this.readFile(filename.toFile());
    }

    public String readFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (this.isFileInsideProject(file)) {
            try {
                return Files.readString(file.toPath(), StandardCharsets.UTF_8);
            }
            catch (MalformedInputException e) {
                return Files.readString(file.toPath(), StandardCharsets.ISO_8859_1);
            }
        }
        throw this.createFileIsNotInProjectException(file);
    }

    private IllegalArgumentException createFileIsNotInProjectException(File file) {
        return new IllegalArgumentException("File " + file.getPath() + " is not inside the project " + String.valueOf(this.getProjectPaths()));
    }

    public List<String> readLines(File file) throws IOException {
        if (!this.isFileInsideProject(file)) {
            throw this.createFileIsNotInProjectException(file);
        }
        return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
    }

    boolean isFileInsideProject(File file) {
        return this.findModule(file).isPresent();
    }

    public static boolean isFileInside(File toCheck, File container) {
        if (!container.exists()) {
            return false;
        }
        if (toCheck.exists()) {
            Path pathToCheck = toCheck.toPath();
            try {
                return pathToCheck.toRealPath(new LinkOption[0]).startsWith(container.toPath().toRealPath(new LinkOption[0]).toString());
            }
            catch (IOException e) {
                ProjectFileManager.getLogger().error("Unable to check if " + String.valueOf(toCheck) + " is inside " + String.valueOf(container), (Throwable)e);
                return false;
            }
        }
        return ProjectFileManager.isFileInside(toCheck.getParentFile(), container);
    }

    public void writeFile(String filename, String undoLabel, String content) throws IOException {
        this.writeFile(this.getAbsolutePath(filename), undoLabel, content);
    }

    public void writeFile(File file, String undoLabel, String content) throws IOException {
        this.writeFile(file, undoLabel, content, false);
    }

    public void writeFile(Path file, String undoLabel, String content) throws IOException {
        this.writeFile(file.toFile(), undoLabel, content, false);
    }

    public File writeFileBase64(String filename, String undoLabel, String base64Content, boolean renameIfExists) throws IOException {
        File target = this.getAbsolutePath(filename);
        while (renameIfExists && target.exists()) {
            target = new File(target.getParentFile(), Util.increaseTrailingNumber(target.getName()));
        }
        this.writeFile(target, undoLabel, base64Content, true);
        return target;
    }

    private void writeFile(File file, String undoLabel, String content, boolean base64Encoded) throws IOException {
        if (!this.isFileInsideProject(file)) {
            throw this.createFileIsNotInProjectException(file);
        }
        File folder = file.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("Unable to create folder " + folder.getAbsolutePath());
        }
        AnalyticsClient.getInstance().track("write-file", Map.of("binary", String.valueOf(base64Encoded), "type", FilenameUtils.getExtension((String)file.getName())));
        CopilotIDEPlugin idePlugin = CopilotIDEPlugin.getInstance();
        if (idePlugin.isActive()) {
            if (base64Encoded && idePlugin.supports(CopilotIDEPlugin.Commands.WRITE_BASE64)) {
                idePlugin.writeBase64File(file, undoLabel, content);
                return;
            }
            if (!base64Encoded && idePlugin.supports(CopilotIDEPlugin.Commands.WRITE)) {
                idePlugin.writeFile(file, undoLabel, content);
                return;
            }
        }
        this.writeFileIfNeeded(file, content, base64Encoded);
    }

    private void writeFileIfNeeded(File file, String content, boolean base64Encoded) throws IOException {
        if (file.exists()) {
            String currentContent;
            if (base64Encoded) {
                byte[] data = FileUtils.readFileToByteArray((File)file);
                currentContent = this.base64Encode(data);
            } else {
                currentContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            if (content.equals(currentContent)) {
                return;
            }
        }
        byte[] data = base64Encoded ? this.base64Decode(content) : content.getBytes(StandardCharsets.UTF_8);
        if (file.exists()) {
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
                int written = channel.write(ByteBuffer.wrap(data));
                channel.truncate(written);
            }
        } else {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        this.copyResourceToTarget(file);
    }

    private void copyResourceToTarget(File resourceFile) throws IOException {
        Optional<Path> maybeResourceFolder = this.findResourceFolder(resourceFile);
        if (maybeResourceFolder.isEmpty()) {
            return;
        }
        File resourceFolder = maybeResourceFolder.get().toFile();
        Optional<JavaSourcePathDetector.ModuleInfo> module = this.findModule(resourceFolder);
        if (module.isEmpty()) {
            ProjectFileManager.getLogger().error("Unable to determine module for resource folder {}", (Object)resourceFolder);
            return;
        }
        String relativeResourceName = ProjectFileManager.getRelativeName(resourceFile, resourceFolder);
        File target = new File(module.get().classesFolder().toFile(), relativeResourceName);
        FileUtils.copyFile((File)resourceFile, (File)target);
    }

    private byte[] base64Decode(String content) {
        return Base64.getDecoder().decode(content);
    }

    private String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public String makeAbsolute(String projectRelativeFilename) throws IOException {
        Path projectRootPath = this.getProjectRoot().toPath().toRealPath(new LinkOption[0]);
        Path resolved = projectRootPath.resolve(projectRelativeFilename).toRealPath(new LinkOption[0]);
        if (!resolved.startsWith(projectRootPath)) {
            throw new IllegalArgumentException("File " + projectRelativeFilename + " is not inside the project at " + String.valueOf(projectRootPath));
        }
        return resolved.toString();
    }

    public String makeRelative(String filename) throws IOException {
        Path projectRootPath = this.getProjectRoot().toPath().toRealPath(new LinkOption[0]);
        Path absolutePath = new File(filename).toPath().toRealPath(new LinkOption[0]);
        if (!absolutePath.startsWith(projectRootPath)) {
            throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(projectRootPath));
        }
        return projectRootPath.relativize(absolutePath).toString();
    }

    public String getProjectRelativeName(File projectFile) {
        return ProjectFileManager.getRelativeName(projectFile, this.getProjectRoot());
    }

    public static String getRelativeName(File projectFile, File folder) {
        return folder.toPath().relativize(projectFile.toPath()).toString();
    }

    public File getFileForClass(Class<?> cls) {
        return this.getFileForClass(cls.getName());
    }

    public File getFileForClass(String cls) {
        if (cls.contains("$")) {
            cls = cls.substring(0, cls.indexOf("$"));
        }
        cls = cls.replace(".", File.separator);
        for (Path path : this.getSourceFolders()) {
            for (String extension : new String[]{"java", "kt"}) {
                String filename = cls + "." + extension;
                File file = new File(path.toFile(), filename);
                if (!file.exists()) continue;
                return file;
            }
        }
        return new File(this.getSourceFolders().get(0).toFile(), cls + ".java");
    }

    public List<Path> getSourceFolders() {
        return this.getProjectPaths().allSourcePaths();
    }

    synchronized JavaSourcePathDetector.ProjectPaths getProjectPaths() {
        if (this.projectPaths0 == null) {
            this.projectPaths0 = JavaSourcePathDetector.detectProjectPaths(this.applicationConfiguration);
            ProjectFileManager.getLogger().debug("Project folders detected: {}", (Object)this.projectPaths0);
        }
        return this.projectPaths0;
    }

    public List<Path> getResourceFolders() {
        return this.getProjectPaths().allResourcePaths();
    }

    public File getSourceFile(ComponentTracker.Location location) {
        return this.getFileForClass(location.className());
    }

    public File getProjectRoot() {
        return this.getProjectPaths().basedir().toFile();
    }

    public File getFrontendFolder() {
        return FrontendUtils.getProjectFrontendDir((AbstractConfiguration)this.applicationConfiguration);
    }

    public File getJavaResourceFolder() {
        return this.applicationConfiguration.getJavaResourceFolder();
    }

    public Optional<String> getThemeName() {
        return ThemeUtils.getThemeName((VaadinContext)this.applicationConfiguration.getContext());
    }

    public Optional<File> getThemeFolder() {
        return this.getThemeName().map(t -> ThemeUtils.getThemeFolder((File)this.getFrontendFolder(), (String)t));
    }

    private File getAbsolutePath(String filename) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(this.getProjectRoot(), filename);
        }
        return file;
    }

    public String sanitizeFilename(String name) {
        return name.replaceAll("[^a-zA-Z0-9-_@]", "_");
    }

    public File getHillaViewsFolder() {
        return new File(this.getFrontendFolder(), "views");
    }

    Optional<Path> findSourceFolder(Class<?> cls) {
        File sourceFile = this.getFileForClass(cls);
        if (!sourceFile.exists()) {
            return Optional.empty();
        }
        return this.findSourceFolder(sourceFile);
    }

    public Optional<Path> findResource(String resource) {
        for (Path resourceFolder : this.getResourceFolders()) {
            Path resourceFile = resourceFolder.resolve(resource);
            if (!resourceFile.toFile().exists()) continue;
            return Optional.of(resourceFile);
        }
        return Optional.empty();
    }

    public Optional<Path> findResourceFolder(File resourceFile) {
        for (Path resourceFolder : this.getResourceFolders()) {
            if (!ProjectFileManager.isFileInside(resourceFile, resourceFolder.toFile())) continue;
            return Optional.of(resourceFolder);
        }
        return Optional.empty();
    }

    public Optional<JavaSourcePathDetector.ModuleInfo> findModule(File file) {
        if (file == null) {
            return Optional.empty();
        }
        for (JavaSourcePathDetector.ModuleInfo moduleInfo : this.getProjectPaths().modules()) {
            if (!ProjectFileManager.isFileInside(file, moduleInfo.rootPath().toFile())) continue;
            return Optional.of(moduleInfo);
        }
        return Optional.empty();
    }

    public Optional<Path> findSourceFolder(File sourceFile) {
        for (Path sourceFolder : this.getSourceFolders()) {
            if (!ProjectFileManager.isFileInside(sourceFile, sourceFolder.toFile())) continue;
            return Optional.of(sourceFolder);
        }
        return Optional.empty();
    }

    public String getJavaPackage(File sourceFile) throws IOException {
        Optional<Path> sourceFolder = this.findSourceFolder(sourceFile);
        if (sourceFolder.isEmpty()) {
            return null;
        }
        return ProjectFileManager.getRelativeName(sourceFile.getParentFile(), sourceFolder.get().toFile()).replace(File.separator, ".");
    }

    public List<JavaSourcePathDetector.ModuleInfo> getModules() {
        return this.getProjectPaths().modules();
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }
}

