/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorAnalyzer {
    public static final int ASM_API = 589824;
    private static final ConstructorAnalyzer INSTANCE = new ConstructorAnalyzer();
    private final Map<String, Map<Integer, String>> constructorParameterMappings = new HashMap<String, Map<Integer, String>>();

    public static ConstructorAnalyzer get() {
        return INSTANCE;
    }

    ConstructorAnalyzer() {
    }

    public Map<Integer, String> getMappings(Constructor<?> constructor) {
        String constructorDescriptor = ConstructorAnalyzer.getConstructorDescriptor(constructor);
        return this.getMappings(constructor.getDeclaringClass().getName(), constructorDescriptor);
    }

    private Map<Integer, String> getMappings(String className, String constructorDescriptor) {
        String mapId = className + "#" + constructorDescriptor;
        if (!this.constructorParameterMappings.containsKey(mapId)) {
            this.constructorParameterMappings.put(mapId, this.getMappingsForConstructor(className, constructorDescriptor));
        }
        return this.constructorParameterMappings.get(mapId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, String> getMappingsForConstructor(String className, String constructorDescriptor) {
        ClassReader cr;
        ClassLoader classLoader = this.getClass().getClassLoader();
        String classFilename = className.replace('.', '/') + ".class";
        try (InputStream classStream = classLoader.getResourceAsStream(classFilename);){
            if (classStream == null) {
                this.getLogger().error("Unable to find class {}", (Object)classFilename);
                Map<Integer, String> map = Collections.emptyMap();
                return map;
            }
            cr = new ClassReader(classStream);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read class " + className, (Throwable)e);
            return Collections.emptyMap();
        }
        ConstructorVisitor visitor = new ConstructorVisitor(constructorDescriptor);
        cr.accept((ClassVisitor)visitor, 0);
        if (visitor.getConstructorCall() == null) return visitor.getMappings();
        String otherClass = visitor.getConstructorCall().classNameSignature;
        Map<Integer, String> otherMappings = this.getMappings(otherClass, visitor.getConstructorCall().descriptor);
        int toIndex = 0;
        while (toIndex < visitor.getConstructorCall().params.size()) {
            int fromIndex = visitor.getConstructorCall().params.get(toIndex);
            String property = otherMappings.get(toIndex);
            if (property != null) {
                visitor.getMappings().put(fromIndex, property);
            }
            ++toIndex;
        }
        return visitor.getMappings();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private static String getConstructorDescriptor(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Type[] types = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            types[i] = Type.getType(parameterTypes[i]);
        }
        return Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])types);
    }

    static class ConstructorVisitor
    extends ClassVisitor {
        private final String constructor;
        private final ConstructorMethodVisitor visitor = new ConstructorMethodVisitor();
        Map<String, String> constructorsCalled = new HashMap<String, String>();

        public ConstructorVisitor(String constructor) {
            super(589824);
            this.constructor = constructor;
        }

        public MethodVisitor visitMethod(int access, String name, String constructorDescriptor, String signature, String[] exceptions) {
            if ("<init>".equals(name) && this.constructor.equals(constructorDescriptor)) {
                return this.visitor;
            }
            return null;
        }

        public Map<Integer, String> getMappings() {
            return this.visitor.mappings;
        }

        ConstructorCall getConstructorCall() {
            return this.visitor.constructorCall;
        }
    }

    record ConstructorCall(String classNameSignature, String descriptor, List<Integer> params) {
    }

    static class ConstructorMethodVisitor
    extends MethodVisitor {
        private final List<Integer> loaded = new ArrayList<Integer>();
        private final Map<Integer, String> mappings = new HashMap<Integer, String>();
        private ConstructorCall constructorCall = null;

        public ConstructorMethodVisitor() {
            super(589824);
        }

        public void visitVarInsn(int opcode, int varIndex) {
            super.visitVarInsn(opcode, varIndex);
            if (opcode == 25) {
                this.loaded.add(varIndex - 1);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 183 && "<init>".equals(name)) {
                if (this.loaded.size() > 1 && this.loaded.get(0) == -1) {
                    this.constructorCall = new ConstructorCall(owner, descriptor, new ArrayList<Integer>(this.loaded.subList(1, this.loaded.size())));
                }
            } else if (name.startsWith("set") && this.loaded.size() == 2 && this.loaded.get(0) == -1) {
                this.mappings.put(this.loaded.get(1), name);
            }
            this.loaded.clear();
        }
    }
}

