/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaBatchRewriter;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaDataProviderHandler;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterCopyPasteHandler;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.SourceSyncChecker;
import com.vaadin.copilot.javarewriter.exception.ComponentInfoNotFoundException;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriteHandler
implements CopilotCommand {
    public static final String UNDO_LABEL = CopilotIDEPlugin.undoLabel("Java view update");
    private static final String CAN_BE_EDITED = "canBeEdited";
    private static final String COMPONENT_ID = "componentId";
    private final ProjectManager projectManager;
    private final SourceSyncChecker sourceSyncChecker;
    private final ComponentSourceFinder sourceFinder;
    private static final String COMPONENT_PROPERTY = "component";
    private static final String PROPERTY_TO_CHECK_PROPERTY = "propertyToCheck";
    private static final String[] supportedEditableProperties = new String[]{"label", "helperText", "text"};
    private final Map<String, RewriteHandler> handlers = new HashMap<String, RewriteHandler>();

    public JavaRewriteHandler(ProjectManager projectManager, SourceSyncChecker sourceSyncChecker) {
        this.projectManager = projectManager;
        this.sourceSyncChecker = sourceSyncChecker;
        this.sourceFinder = new ComponentSourceFinder(projectManager);
        this.handlers.put("set-component-property", new RewriteHandler("set component property", this::handleSetComponentProperty));
        this.handlers.put("add-call", new RewriteHandler("add call", this::handleAddCall));
        this.handlers.put("add-template", new RewriteHandler("add call", this::handleAddTemplate));
        this.handlers.put("delete-components", new RewriteHandler("delete components", this::handleDeleteComponents));
        this.handlers.put("duplicate-components", new RewriteHandler("duplicate components", this::handleDuplicateComponents));
        this.handlers.put("drag-and-drop", new RewriteHandler("drop component", this::handleDragAndDrop));
        this.handlers.put("set-alignment", new RewriteHandler("set alignment", this::handleAlignment));
        this.handlers.put("set-gap", new RewriteHandler("set gap", this::handleGap));
        this.handlers.put("wrap-with", new RewriteHandler("wrap with", this::handleWrapWith));
        this.handlers.put("set-styles", new RewriteHandler("set styles", this::handleSetStyles));
        this.handlers.put("set-padding", new RewriteHandler("set padding", this::handlePadding));
        this.handlers.put("copy", new RewriteHandler("copy", this::handleCopy));
        this.handlers.put("can-be-edited", new RewriteHandler("can be edited", this::handleCanBeEdited));
        this.handlers.put("set-sizing", new RewriteHandler("set sizing", this::handleSetSizing));
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        RewriteHandler handler = this.handlers.get(command);
        if (handler == null) {
            return false;
        }
        String reqId = data.getString("reqId");
        JsonObject respData = Json.createObject();
        respData.put("reqId", reqId);
        try {
            handler.handle(data, respData);
            devToolsInterface.send(command + "-response", respData);
        }
        catch (ComponentInfoNotFoundException e) {
            if (this.sourceSyncChecker.maybeOutOfSync(e)) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, e.getComponentTypeAndSourceLocation().javaFile().getName() + " may be out of sync. Please recompile and deploy the file", e);
            } else {
                this.getLogger().debug("Failed to {} for input {}", new Object[]{handler.getWhat(), data.toJson(), e});
                ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Failed to " + handler.getWhat(), e);
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to {} for input {}", new Object[]{handler.getWhat(), data.toJson(), e});
            ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Failed to " + handler.getWhat(), e);
        }
        return true;
    }

    private void handleAddCall(JsonObject data, JsonObject respData) throws IOException {
        String func = data.getString("func");
        String parameter = data.getString("parameter");
        Integer lineToShowInIde = data.hasKey("lineToShowInIde") ? Integer.valueOf((int)data.getNumber("lineToShowInIde")) : null;
        JsonObject component = data.getObject(COMPONENT_PROPERTY);
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        if (!JavaRewriterUtil.hasSingleParameterMethod(info.type(), func)) {
            throw new IllegalArgumentException("Component " + info.type().getName() + " does not support the given method " + func);
        }
        rewriter.addCall(info, func, new JavaRewriter.Code(parameter));
        String result = rewriter.getResult();
        this.projectManager.writeFile(javaFile, UNDO_LABEL, result);
        if (lineToShowInIde != null) {
            int lineNumber = rewriter.getFirstModifiedRow() + lineToShowInIde;
            IdeUtils.openFile(javaFile, lineNumber);
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(1000L);
                    IdeUtils.openFile(javaFile, lineNumber);
                }
                catch (InterruptedException e) {
                    this.getLogger().error("Failed to show file in IDE", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private void handleDeleteComponents(JsonObject data, JsonObject respData) {
        JsonArray componentsJson = data.getArray("components");
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            List<ComponentTypeAndSourceLocation> found = this.findTypeAndSourceLocationIncludingChildren(componentsJson.getObject(i));
            components.addAll(found);
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, components);
        batchRewriter.deleteAll();
        batchRewriter.writeResult();
    }

    private List<ComponentTypeAndSourceLocation> findTypeAndSourceLocationIncludingChildren(JsonObject object) {
        ArrayList<ComponentTypeAndSourceLocation> all = new ArrayList<ComponentTypeAndSourceLocation>();
        ComponentTypeAndSourceLocation root = this.sourceFinder.findTypeAndSourceLocation(object, true);
        this.addRecursively(all, root);
        return all;
    }

    private void addRecursively(ArrayList<ComponentTypeAndSourceLocation> all, ComponentTypeAndSourceLocation root) {
        all.add(root);
        for (ComponentTypeAndSourceLocation child : root.children()) {
            if (child.javaFile().exists()) {
                this.addRecursively(all, child);
                continue;
            }
            this.getLogger().debug("Excluding file {} because it does not exist. Assuming this is a component created internally by the parent component and not from the project source", (Object)child.javaFile());
        }
    }

    private void handleCopy(JsonObject data, JsonObject response) throws IOException {
        int componentId = (int)data.getNumber(COMPONENT_ID);
        int uiId = (int)data.getNumber("uiId");
        ComponentTypeAndSourceLocation copiedComponent = this.sourceFinder.findTypeAndSourceLocation(uiId, componentId, true);
        JavaRewriterCopyPasteHandler handler = new JavaRewriterCopyPasteHandler(this.projectManager);
        JavaComponent copiedJavaComponent = handler.getCopiedJavaComponent(copiedComponent);
        String s = new ObjectMapper().writeValueAsString((Object)copiedJavaComponent);
        response.put(COMPONENT_PROPERTY, s);
    }

    private void handleDuplicateComponents(JsonObject data, JsonObject respData) {
        JsonArray componentsJson = data.getArray("components");
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        ArrayList<ComponentTypeAndSourceLocation> selectedComponents = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            ComponentTypeAndSourceLocation root = this.sourceFinder.findTypeAndSourceLocation(componentsJson.getObject(i), true);
            selectedComponents.add(root);
            this.addRecursively(components, root);
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, components);
        selectedComponents.forEach(batchRewriter::duplicate);
        batchRewriter.writeResult();
    }

    private void handleWrapWith(JsonObject data, JsonObject respData) throws IOException {
        JsonArray componentsJson = data.getArray("components");
        JavaComponent wrapperComponent = JavaComponent.componentFromJson(data.getObject("wrapperComponent"));
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            components.add(this.sourceFinder.findTypeAndSourceLocation(componentsJson.getObject(i)));
        }
        File javaFile = this.projectManager.getSourceFile(((ComponentTypeAndSourceLocation)components.get(0)).getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        List<ComponentInfo> componentInfos = components.stream().map(rewriter::findComponentInfo).toList();
        rewriter.mergeAndReplace(componentInfos, wrapperComponent);
        String result = rewriter.getResult();
        this.projectManager.writeFile(javaFile, UNDO_LABEL, result);
    }

    private void handleSetComponentProperty(JsonObject data, JsonObject respData) throws IOException {
        String setter;
        ComponentInfo info;
        String property = data.getString("property");
        String value = data.getString("value");
        JsonObject component = data.getObject(COMPONENT_PROPERTY);
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(component);
        if (JavaDataProviderHandler.isDataProviderItemChange(typeAndSourceLocation)) {
            JavaDataProviderHandler dataProviderHandler = new JavaDataProviderHandler(this.projectManager, typeAndSourceLocation);
            JavaDataProviderHandler.JavaDataProviderHandlerResult javaDataProviderHandlerResult = dataProviderHandler.handleSetComponentProperty(property, value);
            this.projectManager.writeFile(javaDataProviderHandlerResult.file(), UNDO_LABEL, javaDataProviderHandlerResult.result());
            return;
        }
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ReplaceResult result = rewriter.replaceFunctionCall(info = rewriter.findComponentInfo(typeAndSourceLocation), setter = JavaRewriterUtil.getSetterName(property, info.type(), true), value);
        if (result.variableRenamedTo() != null) {
            respData.put("variableRenamedTo", result.variableRenamedTo());
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAddTemplate(JsonObject data, JsonObject respData) throws IOException {
        List<JavaComponent> template = JavaComponent.componentsFromJson(data.getArray("template"));
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation refSource = this.sourceFinder.findTypeAndSourceLocation(data.getObject("refNode"));
        File javaFile = this.projectManager.getSourceFile(refSource.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo ref = rewriter.findComponentInfo(refSource);
        JavaRewriter.AddTemplateOptions options = new JavaRewriter.AddTemplateOptions(data.getBoolean("javaFieldsForLeafComponents"));
        if (where == JavaRewriter.Where.APPEND) {
            rewriter.addComponentUsingTemplate(ref, where, template, options);
        } else {
            if (!refSource.parent().javaFile().equals(refSource.javaFile())) {
                throw new IllegalArgumentException("Cannot insert before a component in one file (" + String.valueOf(refSource.javaFile()) + ") when the parent is in another file (" + String.valueOf(refSource.parent().javaFile()) + ")");
            }
            rewriter.addComponentUsingTemplate(ref, where, template, options);
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleDragAndDrop(JsonObject data, JsonObject respData) throws IOException {
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation dragged = this.sourceFinder.findTypeAndSourceLocation(data.getObject("dragged"));
        ComponentTypeAndSourceLocation container = this.sourceFinder.findTypeAndSourceLocation(data.getObject("container"));
        ComponentTypeAndSourceLocation insertBefore = where == JavaRewriter.Where.BEFORE ? this.sourceFinder.findTypeAndSourceLocation(data.getObject("insertBefore")) : null;
        File javaFile = this.projectManager.getSourceFile(container.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        if (!dragged.javaFile().equals(container.javaFile())) {
            throw new IllegalArgumentException("Cannot move a component in one file (" + String.valueOf(dragged.javaFile()) + ") to another file (" + String.valueOf(container.javaFile()) + ")");
        }
        ComponentInfo draggedRef = rewriter.findComponentInfo(dragged);
        ComponentInfo containerRef = rewriter.findComponentInfo(container);
        ComponentInfo insertBeforeRef = insertBefore == null ? null : rewriter.findComponentInfo(insertBefore);
        rewriter.moveComponent(draggedRef, containerRef, insertBeforeRef, where);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAlignment(JsonObject data, JsonObject respData) throws IOException {
        JavaRewriter.AlignmentMode mode = JavaRewriter.AlignmentMode.valueOf(data.getString("alignmentMode").replace('-', '_').toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(data.getObject(COMPONENT_ID));
        JsonArray lumoClassesJson = data.getArray("lumoClasses");
        ArrayList<String> lumoClasses = new ArrayList<String>();
        for (int i = 0; i < lumoClassesJson.length(); ++i) {
            lumoClasses.add(lumoClassesJson.getString(i));
        }
        boolean selected = data.getBoolean("selected");
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setAlignment(componentInfo, mode, selected, lumoClasses);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleSetStyles(JsonObject data, JsonObject respData) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(data.getObject(COMPONENT_ID));
        JsonArray added = data.getArray("added");
        JsonArray removed = data.getArray("removed");
        HashSet<String> toRemove = new HashSet<String>();
        for (int i = 0; i < removed.length(); ++i) {
            toRemove.add(removed.getObject(i).getString("key"));
        }
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        for (int i = 0; i < added.length(); ++i) {
            JsonObject rule = added.getObject(i);
            String key = rule.getString("key");
            String value = rule.getString("value");
            rewriter.setStyle(componentInfo, key, value);
            toRemove.remove(key);
        }
        for (String key : toRemove) {
            rewriter.setStyle(componentInfo, key, null);
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleSetSizing(JsonObject data, JsonObject respData) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(data.getObject(COMPONENT_ID));
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        JsonObject changesJson = data.getObject("changes");
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        HashMap changes = (HashMap)objectMapper.readValue(changesJson.toJson(), (TypeReference)typeRef);
        rewriter.setSizing(componentInfo, changes);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleGap(JsonObject data, JsonObject respData) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(data.getObject(COMPONENT_ID));
        String newValue = data.getString("newValue");
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setGap(componentInfo, newValue);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handlePadding(JsonObject data, JsonObject respData) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(data.getObject(COMPONENT_ID));
        String newClassName = data.hasKey("newClassName") ? data.getString("newClassName") : null;
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setPadding(componentInfo, newClassName);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleCanBeEdited(JsonObject data, JsonObject response) throws IOException {
        JsonObject component = data.getObject(COMPONENT_PROPERTY);
        String propertyToCheck = data.getString(PROPERTY_TO_CHECK_PROPERTY);
        if (Arrays.stream(supportedEditableProperties).noneMatch(property -> property.equalsIgnoreCase(propertyToCheck))) {
            response.put(CAN_BE_EDITED, false);
            return;
        }
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.getCreateLocationOrThrow());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        try {
            Object result = rewriter.getPropertyValue(info, propertyToCheck);
            response.put(CAN_BE_EDITED, result instanceof String);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to check if property can be edited", (Throwable)e);
            response.put(CAN_BE_EDITED, false);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private static class RewriteHandler {
        private final String what;
        private final Handler handler;

        public RewriteHandler(String what, Handler handler) {
            this.what = what;
            this.handler = handler;
        }

        public void handle(JsonObject data, JsonObject respData) throws IOException {
            this.handler.handle(data, respData);
        }

        public String getWhat() {
            return this.what;
        }
    }

    private static interface Handler {
        public void handle(JsonObject var1, JsonObject var2) throws IOException;
    }
}

