package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;

import elemental.json.JsonObject;

public interface CopilotCommand {

    String KEY_REQ_ID = "reqId";
    String KEY_CANCEL_REQ_ID = "requestId";

    boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface);

    default void handleConnect(DevToolsInterface devToolsInterface) {
    }

    /**
     * Checks if given command can be handled asynchronously. If the handler can't
     * be asynchronous at all, it can return false always. But if you want to handle
     * one or more commands asynchronously, you should specify the exact command to
     * prevent handling commands that are not part of the handler as asynchronous.
     * 
     * @param command
     * @return true if the command can be handled by this command handler
     */
    default boolean canBeParallelCommand(String command) {
        return false;
    }
}
