/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.vaadin.copilot.javarewriter.AttachExpression;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.exception.ComponentInfoNotFoundException;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record ComponentInfo(Class<? extends Component> type, ObjectCreationExpr objectCreationExpr, BlockStmt componentCreateScope, AttachExpression attachCall, Optional<BlockStmt> componentAttachScope, VariableDeclarator localVariableDeclarator, AssignExpr assignmentExpression, FieldDeclaration fieldDeclaration, FieldDeclaration fieldDeclarationAndAssignment, String localVariableName, String fieldName, ConstructorDeclaration routeConstructor, boolean containerComposite, boolean isAnonymousComponent, boolean isReturnValue, JavaRewriter rewriter) {
    public static ComponentInfo find(ComponentTypeAndSourceLocation typeAndSourceLocation, JavaRewriter javaRewriter) {
        MethodCallExpr methodCallExpr;
        ComponentTracker.Location createLocation;
        Optional<BlockStmt> componentAttachScope;
        AttachExpression attachCall;
        Optional<FieldDeclaration> fieldDeclarationAndAssignment;
        CompilationUnit compilationUnit = javaRewriter.compilationUnit;
        List<Object> objectCreationExprs = new ArrayList();
        for (Class<?> clazz : typeAndSourceLocation.inheritanceChain()) {
            ComponentTracker.Location createLocationInProject;
            Optional<ComponentTracker.Location> maybeLocationInProject = typeAndSourceLocation.createLocationInProject();
            if (maybeLocationInProject.isEmpty() || (objectCreationExprs = JavaRewriterUtil.findNodesOfType((Node)compilationUnit, (createLocationInProject = maybeLocationInProject.get()).lineNumber(), ObjectCreationExpr.class, node -> node.getType().asClassOrInterfaceType().getName().asString().equals(clazz.getSimpleName()))).isEmpty()) continue;
            break;
        }
        if (objectCreationExprs.size() > 1) {
            throw new IllegalArgumentException("There are multiple components created on the given line and we are unable to determine which one to modify");
        }
        Optional<Object> objectCreationExpr = Optional.ofNullable(objectCreationExprs.isEmpty() ? null : (ObjectCreationExpr)objectCreationExprs.get(0));
        boolean routeClass = false;
        boolean compositeContainer = false;
        boolean isAnonymousComponent = false;
        boolean isReturnValue = false;
        if (objectCreationExpr.isEmpty()) {
            routeClass = JavaRewriterUtil.isRouteClass(typeAndSourceLocation, compilationUnit);
            if (!routeClass) {
                int lineNumber = typeAndSourceLocation.getCreateLocationOrThrow().lineNumber();
                String[] lines = javaRewriter.getSource().split("[\r\n]");
                String lineContents = lines.length > lineNumber ? "\"" + lines[lineNumber - 1].trim() + "\"" : "no line with number " + lineNumber + " as the file only has " + lines.length + " lines";
                throw new ComponentInfoNotFoundException(typeAndSourceLocation, "Expected to find an object creation expression such as \"new " + typeAndSourceLocation.type().getSimpleName() + "()\" at " + typeAndSourceLocation.javaFile().getAbsolutePath() + ":" + lineNumber + " but found " + lineContents);
            }
        } else {
            ObjectCreationExpr n = objectCreationExpr.orElse(null);
            Node parent = n.getParentNode().orElse(null);
            if (!(n == null || parent == null || parent instanceof VariableDeclarator || parent instanceof AssignExpr || parent instanceof FieldDeclaration)) {
                isAnonymousComponent = true;
            }
            if (n != null && parent != null && parent instanceof ReturnStmt) {
                isReturnValue = true;
            }
        }
        Optional<BlockStmt> componentCreateScope = objectCreationExpr.map(JavaRewriterUtil::findBlock);
        Optional<Object> localVariableDeclarator = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, VariableDeclarator.class));
        Optional<AssignExpr> assignmentExpression = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, AssignExpr.class));
        Optional<FieldDeclaration> fieldDeclaration = fieldDeclarationAndAssignment = objectCreationExpr.map(expr -> JavaRewriterUtil.findAncestor((Node)expr, FieldDeclaration.class));
        if (localVariableDeclarator.isPresent() && fieldDeclarationAndAssignment.isPresent()) {
            localVariableDeclarator = Optional.empty();
        }
        String localVariableName = null;
        String fieldName = null;
        if (localVariableDeclarator.isPresent()) {
            localVariableName = ((VariableDeclarator)localVariableDeclarator.get()).getNameAsString();
        } else if (fieldDeclarationAndAssignment.isPresent()) {
            fieldName = fieldDeclarationAndAssignment.get().getVariable(0).getNameAsString();
        } else if (assignmentExpression.isPresent()) {
            String localVariableOrFieldName;
            Expression target = assignmentExpression.get().getTarget();
            if (target.isNameExpr()) {
                localVariableOrFieldName = target.asNameExpr().getNameAsString();
            } else if (target.isFieldAccessExpr()) {
                localVariableOrFieldName = target.asFieldAccessExpr().getNameAsString();
            } else {
                throw new IllegalArgumentException("Unhandled target type for assignment. Expression=" + String.valueOf(target));
            }
            if (componentCreateScope.isPresent() && JavaRewriterUtil.findLocalVariableDeclarator(localVariableOrFieldName, componentCreateScope.get()) != null) {
                localVariableName = localVariableOrFieldName;
            } else {
                fieldName = localVariableOrFieldName;
                fieldDeclaration = Optional.ofNullable(JavaRewriterUtil.findFieldDeclaration((Node)assignmentExpression.get(), fieldName));
            }
        }
        Optional<BlockStmt> attachMethodCall = typeAndSourceLocation.attachLocationInProject().flatMap(location -> JavaRewriterUtil.findNodeOfType((Node)compilationUnit, location.lineNumber(), MethodCallExpr.class));
        if (attachMethodCall.isEmpty() && !routeClass) {
            Optional<BlockStmt> attachObjectCreationCall = typeAndSourceLocation.attachLocationInProject().flatMap(location -> JavaRewriterUtil.findNodeOfType((Node)compilationUnit, location.lineNumber(), ObjectCreationExpr.class));
            if (attachObjectCreationCall.isEmpty()) {
                String varName = localVariableName != null ? localVariableName : fieldName;
                Optional<AttachExpression> possibleAttachExpressionFromParentInfo = ComponentInfo.findPossibleAttachExpressionFromParentInfo(typeAndSourceLocation, objectCreationExpr.orElse(null), varName, javaRewriter);
                if (possibleAttachExpressionFromParentInfo.isEmpty()) {
                    throw new ComponentInfoNotFoundException(typeAndSourceLocation, "Attach not found at the expected location");
                }
                attachCall = possibleAttachExpressionFromParentInfo.get();
                componentAttachScope = Optional.of(JavaRewriterUtil.findBlock(possibleAttachExpressionFromParentInfo.get().getNode()));
            } else {
                componentAttachScope = attachObjectCreationCall.map(JavaRewriterUtil::findBlock);
                attachCall = new AttachExpression(attachObjectCreationCall.orElse(null));
            }
        } else {
            componentAttachScope = attachMethodCall.map(JavaRewriterUtil::findBlock);
            attachCall = new AttachExpression(attachMethodCall.orElse(null));
        }
        Optional<Object> routeConstructor = Optional.empty();
        if (routeClass && (routeConstructor = JavaRewriterUtil.findNodeOfType((Node)compilationUnit, (createLocation = typeAndSourceLocation.getCreateLocationOrThrow()).lineNumber(), ConstructorDeclaration.class)).isEmpty()) {
            List constructors = compilationUnit.findAll(ConstructorDeclaration.class);
            if (constructors.isEmpty()) {
                routeConstructor = Optional.of((ConstructorDeclaration)((ConstructorDeclaration)new ConstructorDeclaration().setName(typeAndSourceLocation.type().getSimpleName())).setPublic(true));
                String className = typeAndSourceLocation.type().getSimpleName();
                ClassOrInterfaceDeclaration classDeclaration = compilationUnit.findAll(ClassOrInterfaceDeclaration.class).stream().filter(c -> c.getNameAsString().equals(className)).findFirst().orElseThrow(() -> new IllegalArgumentException("Class " + className + " not found"));
                classDeclaration.addMember((BodyDeclaration)routeConstructor.get());
            } else {
                throw new ComponentInfoNotFoundException(typeAndSourceLocation, "Route class has constructors but none at the expected location: " + String.valueOf(createLocation));
            }
        }
        if ((compositeContainer = ComponentInfo.isChildOfCompositeContainer(attachCall.expression())) && attachCall.expression().isMethodCallExpr() && (methodCallExpr = attachCall.getMethodCallExpression()) != null && methodCallExpr.getNameAsString().equals("getContent") && methodCallExpr.getParentNode().isPresent()) {
            attachCall = new AttachExpression((Expression)methodCallExpr.getParentNode().get());
        }
        return new ComponentInfo(typeAndSourceLocation.type(), objectCreationExpr.orElse(null), componentCreateScope.orElse(null), attachCall, componentAttachScope, localVariableDeclarator.orElse(null), assignmentExpression.orElse(null), fieldDeclaration.orElse(null), fieldDeclarationAndAssignment.orElse(null), localVariableName, fieldName, routeConstructor.orElse(null), compositeContainer, isAnonymousComponent, isReturnValue, javaRewriter);
    }

    private static boolean isChildOfCompositeContainer(Expression attachCallExpr) {
        if (attachCallExpr == null) {
            return false;
        }
        return JavaRewriterUtil.isNodeInCompositeClass((Node)attachCallExpr);
    }

    private static Optional<AttachExpression> findPossibleAttachExpressionFromParentInfo(ComponentTypeAndSourceLocation componentTypeAndSourceLocation, ObjectCreationExpr objectCreationExpr, String varName, JavaRewriter javaRewriter) {
        if (componentTypeAndSourceLocation.parent() == null) {
            return Optional.empty();
        }
        ArrayList<Object> possibleArgs = new ArrayList<Object>();
        if (varName != null) {
            possibleArgs.add(new NameExpr(varName));
        }
        if (objectCreationExpr != null) {
            possibleArgs.add(objectCreationExpr);
        }
        if (possibleArgs.isEmpty()) {
            return Optional.empty();
        }
        ComponentTypeAndSourceLocation parent = componentTypeAndSourceLocation.parent();
        ComponentInfo componentInfo = ComponentInfo.find(parent, javaRewriter);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        return methodCallStatements.stream().filter(f -> {
            if (!f.getNameAsString().equals("add")) return false;
            if (!f.getArguments().stream().anyMatch(possibleArgs::contains)) return false;
            return true;
        }).findFirst().map(AttachExpression::new);
    }

    public VariableDeclarator getVariableDeclarator() {
        if (this.localVariableDeclarator() != null) {
            return this.localVariableDeclarator();
        }
        if (this.fieldDeclaration() != null) {
            return this.fieldDeclaration().getVariables().stream().filter(variable -> variable.getNameAsString().equals(this.fieldName())).findFirst().orElse(null);
        }
        return null;
    }
}

