/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotCommand;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineConfigurationHandler
implements CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-machine-configuration")) {
            JsonObject response = Json.createObject();
            try {
                File confFile = this.getConfFile();
                if (confFile.exists()) {
                    String json = FileUtils.readFileToString((File)confFile, (Charset)StandardCharsets.UTF_8);
                    MachineConfigurationHandler.getLogger().debug("Reading configuration: {}", (Object)json);
                    response.put("conf", (JsonValue)Json.parse((String)json));
                } else {
                    response.put("conf", (JsonValue)Json.parse((String)"{}"));
                }
            }
            catch (IOException e) {
                MachineConfigurationHandler.getLogger().error("Failed to read machine configuration", (Throwable)e);
                response.put("error", true);
            }
            devToolsInterface.send("copilot-machine-configuration", response);
            return true;
        }
        if (command.equals("set-machine-configuration")) {
            try {
                String json = data.getString("conf");
                FileUtils.write((File)this.getConfFile(), (CharSequence)(json + "\n"), (Charset)StandardCharsets.UTF_8);
                MachineConfigurationHandler.getLogger().debug("Writing configuration: {}", (Object)json);
            }
            catch (IOException e) {
                MachineConfigurationHandler.getLogger().error("Failed to write machine configuration", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MachineConfigurationHandler.class);
    }

    private File getConfFile() {
        return new File(ProjectHelpers.resolveVaadinHomeDirectory(), "copilot-configuration.json");
    }
}

