/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourcePathDetector {
    private JavaSourcePathDetector() {
    }

    public static ProjectPaths detectProjectPaths(ApplicationConfiguration applicationConfiguration) {
        return JavaSourcePathDetector.detectSourceFoldersUsingIDEPlugin().orElseGet(() -> JavaSourcePathDetector.detectSingleModuleSourceFolders(applicationConfiguration));
    }

    private static Optional<ProjectPaths> detectSourceFoldersUsingIDEPlugin() {
        CopilotIDEPlugin plugin = CopilotIDEPlugin.getInstance();
        if (!plugin.isActive()) {
            return Optional.empty();
        }
        try {
            JsonObject sourcePathResponse = plugin.getModulePaths();
            JsonObject project = sourcePathResponse.getObject("project");
            String projectBasePath = project.getString("basePath");
            JsonArray modules = project.getArray("modules");
            ArrayList<ModuleInfo> moduleInfos = new ArrayList<ModuleInfo>();
            for (int i = 0; i < modules.length(); ++i) {
                Path contentRoot;
                Path outputPath;
                JsonObject module = modules.getObject(i);
                String name = module.getString("name");
                List<Path> contentRoots = JavaSourcePathDetector.stringArrayToPathList(module, "contentRoots");
                List<Path> javaSourcePaths = JavaSourcePathDetector.stringArrayToPathList(module, "javaSourcePaths").stream().filter(JavaSourcePathDetector.filterSources()).toList();
                List<Path> javaTestSourcePaths = JavaSourcePathDetector.stringArrayToPathList(module, "javaTestSourcePaths").stream().filter(JavaSourcePathDetector.filterSources()).toList();
                List<Path> resourcePaths = JavaSourcePathDetector.stringArrayToPathList(module, "resourcePaths");
                List<Path> testResourcePaths = JavaSourcePathDetector.stringArrayToPathList(module, "testResourcePaths");
                Path path = outputPath = module.hasKey("outputPath") ? Path.of(module.getString("outputPath"), new String[0]) : null;
                if (JavaSourcePathDetector.isInvalidModule(contentRoots, javaSourcePaths, javaTestSourcePaths, resourcePaths, testResourcePaths)) {
                    JavaSourcePathDetector.getLogger().debug("Ignoring invalid module " + name + " without any paths");
                    continue;
                }
                if (contentRoots.size() == 1) {
                    contentRoot = contentRoots.get(0);
                } else if (contentRoots.isEmpty()) {
                    contentRoot = null;
                    JavaSourcePathDetector.getLogger().warn("No content root found for module {} with Java source paths {}", (Object)name, javaSourcePaths);
                } else {
                    JavaSourcePathDetector.getLogger().warn("Multiple content roots ({}) found for module {} with Java source paths {}", new Object[]{contentRoots, name, javaSourcePaths});
                    contentRoot = contentRoots.get(0);
                }
                moduleInfos.add(new ModuleInfo(name, contentRoot, javaSourcePaths, javaTestSourcePaths, resourcePaths, testResourcePaths, outputPath));
            }
            return Optional.of(JavaSourcePathDetector.filterAndFindRoot(projectBasePath, moduleInfos));
        }
        catch (CopilotIDEPlugin.UnsupportedOperationByPluginException e) {
            return Optional.empty();
        }
    }

    private static boolean isInvalidModule(List<Path> contentRoots, List<Path> javaSourcePaths, List<Path> javaTestSourcePaths, List<Path> resourcePaths, List<Path> testResourcePaths) {
        return contentRoots.isEmpty() && javaSourcePaths.isEmpty() && javaTestSourcePaths.isEmpty() && resourcePaths.isEmpty() && testResourcePaths.isEmpty();
    }

    private static Predicate<Path> filterSources() {
        return path -> !path.endsWith("generated-sources/annotations");
    }

    private static ProjectPaths filterAndFindRoot(String projectBasePath, List<ModuleInfo> moduleInfos) {
        try {
            List<Path> classpathRootFolders = JavaSourcePathDetector.getClasspathModuleRootFolders();
            if (!classpathRootFolders.isEmpty()) {
                moduleInfos = moduleInfos.stream().filter(moduleInfo -> JavaSourcePathDetector.isInAnyFolder(classpathRootFolders, moduleInfo.javaSourcePaths())).toList();
            }
        }
        catch (IOException | URISyntaxException e) {
            JavaSourcePathDetector.getLogger().error("Error filtering source folders using classpath", (Throwable)e);
        }
        Path projectBaseDir = JavaSourcePathDetector.getCommonAncestor(moduleInfos.stream().map(module -> JavaSourcePathDetector.getCommonAncestor(module.javaSourcePaths(), module.javaTestSourcePaths(), module.resourcePaths(), module.testResourcePaths(), List.of(module.rootPath()))).toList());
        Path projectBaseDirFromIde = Path.of(projectBasePath, new String[0]);
        if (!projectBaseDir.equals(projectBaseDirFromIde)) {
            JavaSourcePathDetector.getLogger().warn("Calculated project directory ({}) and directory reported by IDE ({}) do not match. Using {} and hoping for the best", new Object[]{projectBaseDir, projectBaseDirFromIde, projectBaseDirFromIde});
            projectBaseDir = projectBaseDirFromIde;
        }
        return JavaSourcePathDetector.createProjectPaths(projectBaseDir, moduleInfos);
    }

    private static ProjectPaths createProjectPaths(Path projectBaseDir, List<ModuleInfo> modules) {
        ArrayList<Path> allSourcePaths = new ArrayList<Path>();
        allSourcePaths.addAll(modules.stream().flatMap(moduleInfo -> moduleInfo.javaSourcePaths().stream()).toList());
        allSourcePaths.addAll(modules.stream().flatMap(moduleInfo -> moduleInfo.javaTestSourcePaths().stream()).toList());
        ArrayList<Path> allResourcePaths = new ArrayList<Path>();
        allResourcePaths.addAll(modules.stream().flatMap(moduleInfo -> moduleInfo.resourcePaths().stream()).toList());
        allResourcePaths.addAll(modules.stream().flatMap(moduleInfo -> moduleInfo.testResourcePaths().stream()).toList());
        return new ProjectPaths(projectBaseDir, modules, allSourcePaths, allResourcePaths);
    }

    @SafeVarargs
    private static Path getCommonAncestor(List<Path> ... folders) {
        List<Path> allPaths = Arrays.stream(folders).flatMap(Collection::stream).toList();
        Optional<Path> projectRoot = Util.findCommonAncestor(allPaths);
        if (projectRoot.isEmpty()) {
            throw new IllegalStateException("Unable to deduce project folder using source paths: " + String.valueOf(allPaths));
        }
        return projectRoot.get();
    }

    private static List<Path> getClasspathModuleRootFolders() throws IOException, URISyntaxException {
        return JavaSourcePathDetector.getClasspathClassesFolders().stream().map(JavaSourcePathDetector::getProjectFolderFromClasspath).filter(Objects::nonNull).toList();
    }

    private static Path getProjectFolderFromClasspath(Path classesFolder) {
        return classesFolder.endsWith(Path.of("target", "classes")) ? classesFolder.getParent().getParent() : null;
    }

    private static boolean isInAnyFolder(List<Path> folders, List<Path> targets) {
        return folders.stream().anyMatch(folder -> targets.stream().anyMatch(target -> ProjectManager.isFileInside(target.toFile(), folder.toFile())));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaSourcePathDetector.class);
    }

    private static List<Path> getClasspathClassesFolders() throws IOException, URISyntaxException {
        Enumeration<URL> resources = JavaSourcePathDetector.class.getClassLoader().getResources(".");
        ArrayList<Path> paths = new ArrayList<Path>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            Path path = Path.of(url.toURI());
            paths.add(path);
        }
        return paths;
    }

    private static List<Path> stringArrayToPathList(JsonObject jsonObject, String key) {
        JsonArray pathsJson = jsonObject.getArray(key);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < pathsJson.length(); ++i) {
            paths.add(Path.of(pathsJson.getString(i), new String[0]));
        }
        return paths;
    }

    static ProjectPaths detectSingleModuleSourceFolders(ApplicationConfiguration applicationConfiguration) {
        Path javaSourcePath = applicationConfiguration.getJavaSourceFolder().toPath();
        Path javaTestSourcePath = Util.replaceFolderInPath(javaSourcePath, "main", "test", "src");
        Path javaResourcePath = applicationConfiguration.getJavaResourceFolder().toPath();
        Path javaTestResourcePath = Util.replaceFolderInPath(javaResourcePath, "main", "test", "src");
        Path kotlinSourcePath = Util.replaceFolderInPath(javaSourcePath, "java", "kotlin", "main");
        Path kotlinTestSourcePath = Util.replaceFolderInPath(kotlinSourcePath, "main", "test", "src");
        Path rootPath = applicationConfiguration.getProjectFolder().toPath();
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        sourcePaths.addAll(JavaSourcePathDetector.existingList(javaSourcePath));
        sourcePaths.addAll(JavaSourcePathDetector.existingList(kotlinSourcePath));
        ArrayList<Path> testSourcePaths = new ArrayList<Path>();
        testSourcePaths.addAll(JavaSourcePathDetector.existingList(javaTestSourcePath));
        testSourcePaths.addAll(JavaSourcePathDetector.existingList(kotlinTestSourcePath));
        ModuleInfo module = new ModuleInfo(rootPath.getFileName().toString(), rootPath, sourcePaths, testSourcePaths, JavaSourcePathDetector.existingList(javaResourcePath), JavaSourcePathDetector.existingList(javaTestResourcePath), JavaSourcePathDetector.getSingleModuleClassesFolder(rootPath, applicationConfiguration.getBuildFolder()));
        return JavaSourcePathDetector.createProjectPaths(module.rootPath(), List.of(module));
    }

    private static Path getSingleModuleClassesFolder(Path moduleRoot, String buildFolder) {
        Path buildFolderPath = Path.of(buildFolder, new String[0]);
        if (!buildFolderPath.isAbsolute()) {
            buildFolderPath = moduleRoot.resolve(buildFolderPath);
        }
        return buildFolderPath.resolve("classes");
    }

    private static List<Path> existingList(Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Collections.singletonList(path);
    }

    public record ProjectPaths(Path basedir, List<ModuleInfo> modules, List<Path> allSourcePaths, List<Path> allResourcePaths) {
    }

    public record ModuleInfo(String name, Path rootPath, List<Path> javaSourcePaths, List<Path> javaTestSourcePaths, List<Path> resourcePaths, List<Path> testResourcePaths, Path classesFolder) {
        public Optional<Path> getOrGuessResourceFolder() {
            if (!this.resourcePaths.isEmpty()) {
                return Optional.of(this.resourcePaths.get(0));
            }
            if (!this.javaSourcePaths.isEmpty()) {
                return Optional.of(this.javaSourcePaths.get(0).getParent().resolve("resources"));
            }
            return Optional.empty();
        }
    }
}

