package com.vaadin.copilot.plugins.docs;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;

import elemental.json.Json;
import elemental.json.JsonObject;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocsHandler implements CopilotCommand {

    private final ObjectMapper objectMapper;
    private final DocsDataLoader docsDataLoader;

    public DocsHandler() {
        this.objectMapper = new ObjectMapper();
        this.docsDataLoader = new DocsDataLoader();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-docs")) {
            var reqId = data.getString(KEY_REQ_ID);
            var responseData = Json.createObject();
            responseData.put(KEY_REQ_ID, reqId);
            try {
                DocsRequest docsRequest = objectMapper.readValue(data.toJson(), DocsRequest.class);
                DocsResponse response = docsDataLoader.get(docsRequest);
                responseData.put("content", objectMapper.writeValueAsString(response));
            } catch (DocsException exception) {
                responseData.put("error", exception.getCode());
            } catch (Exception ex) {
                responseData.put("error", DocsException.UNKNOWN_ERROR);
                getLogger().error(ex.getMessage(), ex);
            }
            devToolsInterface.send("copilot-get-docs-response", responseData);

            return true;
        }
        return false;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

    @Override
    public boolean canBeParallelCommand(String command) {
        return command.equalsIgnoreCase("get-docs");
    }
}
