/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ai;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.communication.CopilotServerResponseCode;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AICommunicationUtil {
    public static void promptTextCannotCall(JsonObject data, DevToolsInterface devToolsInterface) {
        AICommunicationUtil.getLogger().error("Cannot call AI without a proKey or machineId present.");
        JsonObject responseData = Json.createObject();
        if (data.hasKey("reqId")) {
            responseData.put("reqId", data.getString("reqId"));
        }
        responseData.put("error", true);
        responseData.put("code", (double)CopilotServerResponseCode.COPILOT_AUTHORISATION_FAILED.getCode());
        devToolsInterface.send("copilot-prompt-failed", responseData);
    }

    public static Map<String, String> getHillaSourceFiles(JsonObject data) {
        LinkedHashMap<String, String> sources = new LinkedHashMap<String, String>();
        JsonArray reactSources = data.getArray("sources");
        if (reactSources != null) {
            for (int i = 0; i < reactSources.length(); ++i) {
                JsonObject source = reactSources.getObject(i);
                AICommunicationUtil.getLogger().debug("Hilla file: {}", (Object)source.getString("filename"));
                sources.put(source.getString("filename"), source.getString("projectFile"));
            }
        }
        return sources;
    }

    public static void handlingExceptionsAndNotifyDevtoolsInterface(JsonObject dataJson, DevToolsInterface devToolsInterface, Throwable e) {
        JsonObject responseData = Json.createObject();
        if (dataJson.hasKey("reqId")) {
            responseData.put("reqId", dataJson.getString("reqId"));
        }
        if (e.getCause() instanceof TimeoutException) {
            responseData.put("code", -301.0);
        } else {
            responseData.put("code", -300.0);
        }
        responseData.put("message", "Error querying copilot server");
        AICommunicationUtil.getLogger().error("Error querying copilot server", e);
        devToolsInterface.send("copilot-prompt-failed", responseData);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AICommunicationUtil.class);
    }
}

