/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.analytics;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.analytics.AnalyticsClient;
import elemental.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsInterceptor
implements CopilotCommand {
    static final String CONTEXT = "context";
    private final AnalyticsClient analyticsClient;

    public AnalyticsInterceptor(AnalyticsClient analyticsClient) {
        this.analyticsClient = analyticsClient;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        Map<String, String> context = this.toMap(data.getObject(CONTEXT));
        data.remove(CONTEXT);
        if (command.equals("track-event")) {
            if (this.analyticsClient != null) {
                String event = "copilot-" + data.getString("event");
                JsonObject properties = data.getObject("properties");
                this.analyticsClient.track(event, this.toMap(properties), context);
            }
            return true;
        }
        return false;
    }

    private Map<String, String> toMap(JsonObject data) {
        if (data == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : data.keys()) {
            map.put(key, data.get(key).asString());
        }
        return map;
    }
}

