/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.Util;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class ProjectManager {
    final Path javaSourceFolder;
    final Path javaTestSourceFolder;
    final Path kotlinSourceFolder;
    final Path kotlinTestSourceFolder;
    private final Path projectRoot;
    private final ApplicationConfiguration applicationConfiguration;
    private final CopilotIDEPlugin idePlugin;
    private final VaadinSession vaadinSession;

    public ProjectManager(ApplicationConfiguration applicationConfiguration, VaadinSession vaadinSession) throws IOException {
        this.projectRoot = applicationConfiguration.getProjectFolder().toPath().toRealPath(new LinkOption[0]);
        this.javaSourceFolder = applicationConfiguration.getJavaSourceFolder().toPath();
        this.javaTestSourceFolder = Util.replaceFolderInPath(this.javaSourceFolder, "main", "test", "src");
        this.kotlinSourceFolder = Util.replaceFolderInPath(this.javaSourceFolder, "java", "kotlin", "main");
        this.kotlinTestSourceFolder = Util.replaceFolderInPath(this.kotlinSourceFolder, "main", "test", "src");
        this.applicationConfiguration = applicationConfiguration;
        this.vaadinSession = vaadinSession;
        this.idePlugin = CopilotIDEPlugin.getInstance();
    }

    public String readFile(String filename) throws IOException {
        return this.readFile(new File(filename));
    }

    public String readFile(Path filename) throws IOException {
        return this.readFile(filename.toFile());
    }

    public String readFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (this.isFileInsideProject(file)) {
            try {
                return Files.readString(file.toPath(), StandardCharsets.UTF_8);
            }
            catch (MalformedInputException e) {
                return Files.readString(file.toPath(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
    }

    public List<String> readLines(File file) throws IOException {
        if (!this.isFileInsideProject(file)) {
            throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
    }

    boolean isFileInsideProject(File file) throws IOException {
        return this.isFileInside(file, this.projectRoot.toFile());
    }

    private boolean isFileInside(File toCheck, File container) throws IOException {
        if (!container.exists()) {
            return false;
        }
        if (toCheck.exists()) {
            Path pathToCheck = toCheck.toPath();
            return pathToCheck.toRealPath(new LinkOption[0]).startsWith(container.toPath().toRealPath(new LinkOption[0]).toString());
        }
        return this.isFileInside(toCheck.getParentFile(), container);
    }

    public void writeFile(String filename, String undoLabel, String content) throws IOException {
        this.writeFile(this.getAbsolutePath(filename), undoLabel, content);
    }

    public void writeFile(File file, String undoLabel, String content) throws IOException {
        this.writeFile(file, undoLabel, content, false);
    }

    public void writeFile(Path file, String undoLabel, String content) throws IOException {
        this.writeFile(file.toFile(), undoLabel, content, false);
    }

    public File writeFileBase64(String filename, String undoLabel, String base64Content, boolean renameIfExists) throws IOException {
        File target = this.getAbsolutePath(filename);
        while (renameIfExists && target.exists()) {
            target = new File(target.getParentFile(), Util.increaseTrailingNumber(target.getName()));
        }
        this.writeFile(target, undoLabel, base64Content, true);
        return target;
    }

    private void writeFile(File file, String undoLabel, String content, boolean base64Encoded) throws IOException {
        if (this.isFileInsideProject(file)) {
            File folder = file.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Unable to create folder " + folder.getAbsolutePath());
            }
            if (this.idePlugin.isActive()) {
                if (base64Encoded && this.idePlugin.supports(CopilotIDEPlugin.Commands.WRITE_BASE64)) {
                    this.idePlugin.writeBase64File(file, undoLabel, content);
                    return;
                }
                if (!base64Encoded && this.idePlugin.supports(CopilotIDEPlugin.Commands.WRITE)) {
                    this.idePlugin.writeFile(file, undoLabel, content);
                    return;
                }
            }
        } else {
            throw new IllegalArgumentException("File " + file.getPath() + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        this.writeFileIfNeeded(file, content, base64Encoded);
    }

    private void writeFileIfNeeded(File file, String content, boolean base64Encoded) throws IOException {
        if (file.exists()) {
            String currentContent;
            if (base64Encoded) {
                byte[] data = FileUtils.readFileToByteArray((File)file);
                currentContent = this.base64Encode(data);
            } else {
                currentContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            if (content.equals(currentContent)) {
                return;
            }
        }
        byte[] data = base64Encoded ? this.base64Decode(content) : content.getBytes(StandardCharsets.UTF_8);
        if (file.exists()) {
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
                int written = channel.write(ByteBuffer.wrap(data));
                channel.truncate(written);
            }
        } else {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        this.copyResourceToTarget(file);
    }

    private void copyResourceToTarget(File resourceFile) throws IOException {
        if (!this.isFileInside(resourceFile, this.getJavaResourceFolder())) {
            return;
        }
        String relativeResourceName = ProjectManager.getRelativeName(resourceFile, this.getJavaResourceFolder());
        File target = new File(this.getClassesFolder(), relativeResourceName);
        FileUtils.copyFile((File)resourceFile, (File)target);
    }

    private File getBuildFolder() {
        String buildFolder = this.applicationConfiguration.getBuildFolder();
        File buildFolderFile = new File(buildFolder);
        if (buildFolderFile.isAbsolute()) {
            return buildFolderFile;
        }
        return new File(this.projectRoot.toFile(), buildFolder);
    }

    private File getClassesFolder() {
        return new File(this.getBuildFolder(), "classes");
    }

    private byte[] base64Decode(String content) {
        return Base64.getDecoder().decode(content);
    }

    private String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public String makeAbsolute(String projectRelativeFilename) throws IOException {
        Path resolved = this.projectRoot.resolve(projectRelativeFilename).toRealPath(new LinkOption[0]);
        if (!resolved.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + projectRelativeFilename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return resolved.toString();
    }

    public String makeRelative(String filename) throws IOException {
        Path absolutePath = new File(filename).toPath().toRealPath(new LinkOption[0]);
        if (!absolutePath.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return this.projectRoot.relativize(absolutePath).toString();
    }

    public String getProjectRelativeName(File projectFile) {
        return ProjectManager.getRelativeName(projectFile, this.projectRoot.toFile());
    }

    private static String getRelativeName(File projectFile, File folder) {
        return projectFile.toPath().relativize(folder.toPath()).toString();
    }

    public File getFileForClass(Class<?> cls) {
        return this.getFileForClass(cls.getName());
    }

    public File getFileForClass(String cls) {
        if (cls.contains("$")) {
            cls = cls.substring(0, cls.indexOf("$"));
        }
        cls = cls.replace(".", File.separator);
        for (Path path : new Path[]{this.javaSourceFolder, this.javaTestSourceFolder, this.kotlinSourceFolder, this.kotlinTestSourceFolder}) {
            for (String extension : new String[]{"java", "kt"}) {
                String filename = cls + "." + extension;
                File file = new File(path.toFile(), filename);
                if (!file.exists()) continue;
                return file;
            }
        }
        return new File(this.javaSourceFolder.toFile(), cls + ".java");
    }

    public File getSourceFile(ComponentTracker.Location location) {
        return this.getFileForClass(location.className());
    }

    public File getJavaSourceFolder() {
        return this.javaSourceFolder.toFile();
    }

    public File getProjectRoot() {
        return this.projectRoot.toFile();
    }

    public File getFrontendFolder() {
        return FrontendUtils.getProjectFrontendDir((AbstractConfiguration)this.applicationConfiguration);
    }

    public File getJavaResourceFolder() {
        return this.applicationConfiguration.getJavaResourceFolder();
    }

    public Optional<String> getThemeName() {
        return ThemeUtils.getThemeName((VaadinContext)this.applicationConfiguration.getContext());
    }

    public Optional<File> getThemeFolder() {
        return this.getThemeName().map(t -> ThemeUtils.getThemeFolder((File)this.getFrontendFolder(), (String)t));
    }

    private File getAbsolutePath(String filename) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(this.projectRoot.toFile(), filename);
        }
        return file;
    }

    public String sanitizeFilename(String name) {
        return name.replaceAll("[^a-zA-Z0-9-_@]", "_");
    }

    public File getHillaViewsFolder() {
        return new File(this.getFrontendFolder(), "views");
    }

    public String getFlowViewsPackage() {
        HashSet viewPackages = new HashSet();
        this.vaadinSession.accessSynchronously((Command & Serializable)() -> {
            RouteRegistry routeRegistry = this.vaadinSession.getService().getRouter().getRegistry();
            for (RouteData route : routeRegistry.getRegisteredRoutes()) {
                viewPackages.add(route.getNavigationTarget().getPackageName());
            }
        });
        if (viewPackages.size() == 1) {
            return (String)viewPackages.iterator().next();
        }
        String commonPrefix = "";
        for (String viewPackage : viewPackages) {
            if (commonPrefix.isEmpty()) {
                commonPrefix = viewPackage;
                continue;
            }
            if (viewPackage.startsWith(commonPrefix)) continue;
            while (!commonPrefix.isEmpty() && !viewPackage.startsWith(commonPrefix)) {
                commonPrefix = commonPrefix.substring(0, commonPrefix.lastIndexOf(46));
            }
        }
        if (!commonPrefix.isEmpty()) {
            return commonPrefix;
        }
        return this.getMainPackage() + ".views";
    }

    private String getMainPackage() {
        File packageFolder = Util.getSinglePackage(this.getJavaSourceFolder());
        return ProjectManager.getRelativeName(packageFolder, this.getJavaSourceFolder()).replace(File.separator, ".");
    }

    public VaadinSession getVaadinSession() {
        return this.vaadinSession;
    }
}

