/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeIntegration {
    private final ProjectManager projectManager;
    private final ComponentSourceFinder sourceFinder;

    public IdeIntegration(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.sourceFinder = new ComponentSourceFinder(projectManager);
    }

    public void showComponentCreateInIde(Component component) {
        this.internalShowInIde(component, this.sourceFinder.findTypeAndSourceLocation(component, false).getCreateLocationOrThrow());
    }

    public void showComponentAttachInIde(Component component) {
        this.internalShowInIde(component, this.sourceFinder.findTypeAndSourceLocation(component, false).getAttachLocationOrThrow());
    }

    private void internalShowInIde(Component component, ComponentTracker.Location location) {
        if (location == null) {
            IdeIntegration.getLogger().error("Unable to find the location where the component {} was created", (Object)component.getClass().getName());
            return;
        }
        File sourceFile = this.projectManager.getFileForClass(location.className());
        if (sourceFile == null || !sourceFile.exists()) {
            IdeIntegration.getLogger().error("Unable to find source file for class {}", (Object)location.className());
            return;
        }
        IdeUtils.openFile(sourceFile, location.lineNumber());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IdeIntegration.class);
    }
}

