/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.analytics;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.analytics.AnalyticsClient;
import elemental.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsInterceptor
implements CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("browser-info")) {
            AnalyticsClient.getInstance().setUserContext(this.toMap(data));
            return true;
        }
        if (command.equals("track-event")) {
            String event = data.getString("event");
            JsonObject properties = data.getObject("properties");
            AnalyticsClient.getInstance().track(event, this.toMap(properties));
            return true;
        }
        return false;
    }

    private Map<String, String> toMap(JsonObject data) {
        if (data == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : data.keys()) {
            map.put(key, data.get(key).asString());
        }
        return map;
    }
}

