/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.copilot.Util;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class ProjectManager {
    private final ApplicationConfiguration applicationConfiguration;
    private final VaadinSession vaadinSession;

    public ProjectManager(ApplicationConfiguration applicationConfiguration, VaadinSession vaadinSession) throws IOException {
        this.applicationConfiguration = applicationConfiguration;
        this.vaadinSession = vaadinSession;
    }

    public String readFile(String filename) throws IOException {
        return ProjectFileManager.getInstance().readFile(filename);
    }

    public String readFile(Path filename) throws IOException {
        return ProjectFileManager.getInstance().readFile(filename);
    }

    public String readFile(File file) throws IOException {
        return ProjectFileManager.getInstance().readFile(file);
    }

    public List<String> readLines(File file) throws IOException {
        return ProjectFileManager.getInstance().readLines(file);
    }

    boolean isFileInsideProject(File file) {
        return ProjectFileManager.getInstance().isFileInsideProject(file);
    }

    public static boolean isFileInside(File toCheck, File container) {
        return ProjectFileManager.isFileInside(toCheck, container);
    }

    public void writeFile(String filename, String undoLabel, String content) throws IOException {
        ProjectFileManager.getInstance().writeFile(filename, undoLabel, content);
    }

    public void writeFile(File file, String undoLabel, String content) throws IOException {
        ProjectFileManager.getInstance().writeFile(file, undoLabel, content);
    }

    public void writeFile(Path file, String undoLabel, String content) throws IOException {
        ProjectFileManager.getInstance().writeFile(file, undoLabel, content);
    }

    public File writeFileBase64(String filename, String undoLabel, String base64Content, boolean renameIfExists) throws IOException {
        return ProjectFileManager.getInstance().writeFileBase64(filename, undoLabel, base64Content, renameIfExists);
    }

    public String makeAbsolute(String projectRelativeFilename) throws IOException {
        return ProjectFileManager.getInstance().makeAbsolute(projectRelativeFilename);
    }

    public String makeRelative(String filename) throws IOException {
        return ProjectFileManager.getInstance().makeRelative(filename);
    }

    public String getProjectRelativeName(File projectFile) {
        return ProjectFileManager.getRelativeName(projectFile, ProjectFileManager.getInstance().getProjectRoot());
    }

    static String getRelativeName(File projectFile, File folder) {
        return ProjectFileManager.getRelativeName(projectFile, folder);
    }

    public File getFileForClass(Class<?> cls) {
        return ProjectFileManager.getInstance().getFileForClass(cls);
    }

    public File getFileForClass(String cls) {
        return ProjectFileManager.getInstance().getFileForClass(cls);
    }

    public List<Path> getSourceFolders() {
        return ProjectFileManager.getInstance().getSourceFolders();
    }

    public File getSourceFile(ComponentTracker.Location location) {
        return this.getFileForClass(location.className());
    }

    public File getProjectRoot() {
        return ProjectFileManager.getInstance().getProjectRoot();
    }

    public File getFrontendFolder() {
        return ProjectFileManager.getInstance().getFrontendFolder();
    }

    public File getJavaResourceFolder() {
        return ProjectFileManager.getInstance().getJavaResourceFolder();
    }

    public Optional<String> getThemeName() {
        return ProjectFileManager.getInstance().getThemeName();
    }

    public Optional<File> getThemeFolder() {
        return ProjectFileManager.getInstance().getThemeFolder();
    }

    public String sanitizeFilename(String name) {
        return ProjectFileManager.getInstance().sanitizeFilename(name);
    }

    public File getHillaViewsFolder() {
        return ProjectFileManager.getInstance().getHillaViewsFolder();
    }

    public File getFlowNewViewFolder() {
        File folder;
        Optional<Path> folder2;
        Class<?> springApplicationClass;
        HashMap viewPackages = new HashMap();
        this.vaadinSession.accessSynchronously((Command & Serializable)() -> {
            RouteRegistry routeRegistry = this.vaadinSession.getService().getRouter().getRegistry();
            for (RouteData route : routeRegistry.getRegisteredRoutes()) {
                viewPackages.put(route.getNavigationTarget().getPackageName(), route.getNavigationTarget());
            }
        });
        if (!viewPackages.isEmpty()) {
            File someViewJavaFile = this.getFileForClass((Class)viewPackages.values().iterator().next());
            if (viewPackages.size() == 1) {
                return someViewJavaFile.getParentFile();
            }
            String commonPrefix = "";
            for (String viewPackage : viewPackages.keySet()) {
                if (commonPrefix.isEmpty()) {
                    commonPrefix = viewPackage;
                    continue;
                }
                if (viewPackage.startsWith(commonPrefix)) continue;
                while (!commonPrefix.isEmpty() && !viewPackage.startsWith(commonPrefix)) {
                    commonPrefix = commonPrefix.substring(0, commonPrefix.lastIndexOf(46));
                }
            }
            Optional<Path> sourceFolder = this.findSourceFolder(someViewJavaFile);
            if (!commonPrefix.isEmpty()) {
                for (String folder3 : commonPrefix.split("\\.")) {
                    sourceFolder = sourceFolder.map(p -> p.resolve(folder3));
                }
                if (sourceFolder.isPresent()) {
                    return sourceFolder.get().toFile();
                }
            }
        }
        Path sourceFolder = this.getSourceFolders().get(0);
        if (SpringBridge.isSpringAvailable() && (springApplicationClass = SpringBridge.getApplicationClass(this.getVaadinContext())) != null && (folder2 = this.findSourceFolder(springApplicationClass)).isPresent()) {
            sourceFolder = folder2.get();
        }
        if ((folder = Util.getSinglePackage(sourceFolder.toFile())).getName().equals("views")) {
            return folder;
        }
        return new File(folder, "views");
    }

    Optional<Path> findSourceFolder(Class<?> cls) {
        File sourceFile = this.getFileForClass(cls);
        if (!sourceFile.exists()) {
            return Optional.empty();
        }
        return this.findSourceFolder(sourceFile);
    }

    public Optional<Path> findResource(String resource) {
        return ProjectFileManager.getInstance().findResource(resource);
    }

    public Optional<Path> findSourceFolder(File sourceFile) {
        return ProjectFileManager.getInstance().findSourceFolder(sourceFile);
    }

    public VaadinSession getVaadinSession() {
        return this.vaadinSession;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    private VaadinServletContext getVaadinContext() {
        return (VaadinServletContext)this.getVaadinSession().getService().getContext();
    }

    public String getJavaPackage(File sourceFile) throws IOException {
        return ProjectFileManager.getInstance().getJavaPackage(sourceFile);
    }
}

