/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.ide.CopilotIDEPluginProperties;
import com.vaadin.copilot.ide.IDEPluginInfo;
import com.vaadin.copilot.ide.IdeNotification;
import com.vaadin.copilot.ide.IdeUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotIDEPlugin {
    private static final String UNDO_REDO_PREFIX = "Vaadin Copilot";
    private static final String COPILOT_PLUGIN_DOTFILE = ".copilot-plugin";
    private static final int SELECTOR_TIMEOUT = 1000;
    private static Path projectRoot;
    private static DevToolsInterface devToolsInterface;
    private static CopilotIDEPlugin INSTANCE;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Optional<IdeUtils.IDE> ideThatLaunchedTheApplication = IdeUtils.findIde();

    private CopilotIDEPlugin() {
    }

    public static CopilotIDEPlugin getInstance() {
        if (INSTANCE == null) {
            if (projectRoot == null) {
                throw new IllegalStateException("Use setProjectRoot before getting instance of CopilotIDEPlugin");
            }
            INSTANCE = new CopilotIDEPlugin();
        }
        return INSTANCE;
    }

    public static void setProjectRoot(Path projectRoot) {
        CopilotIDEPlugin.projectRoot = projectRoot;
    }

    public static void setDevToolsInterface(DevToolsInterface devToolsInterface) {
        CopilotIDEPlugin.devToolsInterface = devToolsInterface;
    }

    public boolean isActive() {
        return this.getDotFile() != null;
    }

    public CopilotIDEPluginProperties getProperties() {
        return new CopilotIDEPluginProperties(this.getDotFile());
    }

    public IDEPluginInfo getPluginInfo() {
        if (!this.isActive()) {
            return new IDEPluginInfo(false, IdeUtils.findIde().map(IdeUtils.IDE::getPluginIde).orElse(null));
        }
        CopilotIDEPluginProperties props = new CopilotIDEPluginProperties(this.getDotFile());
        return new IDEPluginInfo(true, props.getVersion(), props.getSupportedActions(), props.getIde());
    }

    private String getProjectBasePath() throws IOException {
        File dotFile = this.getDotFile();
        if (dotFile == null) {
            throw new IOException("Dot file not found");
        }
        return dotFile.toPath().toRealPath(new LinkOption[0]).getParent().getParent().toString();
    }

    private File getDotFile() {
        if (this.ideThatLaunchedTheApplication.isPresent()) {
            return this.getDotFile(this.ideThatLaunchedTheApplication.get());
        }
        for (IdeUtils.IDE ide : IdeUtils.IDE.values()) {
            File dotFile = this.getDotFile(ide);
            if (dotFile == null) continue;
            return dotFile;
        }
        return null;
    }

    private File getDotFile(IdeUtils.IDE ide) {
        File dotFile;
        Path dir = projectRoot;
        do {
            dotFile = dir.resolve(ide.getMetaDir()).resolve(COPILOT_PLUGIN_DOTFILE).toFile();
        } while ((dir = dir.getParent()) != null && !dotFile.exists());
        if (dotFile.exists() && dotFile.canRead()) {
            return dotFile;
        }
        return null;
    }

    private void removeDotFile() throws IOException {
        Optional.ofNullable(this.getDotFile()).ifPresent(File::delete);
    }

    public JsonObject writeFile(File file, String undoLabel, String content) throws IOException {
        if (!this.supports(Commands.WRITE)) {
            throw new UnsupportedOperationByPluginException(Commands.WRITE);
        }
        WriteFileMessage data = new WriteFileMessage(file.getAbsolutePath(), undoLabel, content);
        return this.send(Commands.WRITE.create(data));
    }

    public JsonObject writeBase64File(File file, String undoLabel, String content) throws IOException {
        if (!this.supports(Commands.WRITE_BASE64)) {
            throw new UnsupportedOperationByPluginException(Commands.WRITE_BASE64);
        }
        WriteFileMessage data = new WriteFileMessage(file.getAbsolutePath(), undoLabel, content);
        return this.send(Commands.WRITE_BASE64.create(data));
    }

    public JsonObject undo(List<String> files) throws IOException {
        if (!this.supports(Commands.UNDO)) {
            throw new UnsupportedOperationByPluginException(Commands.UNDO);
        }
        UndoRedoMessage data = new UndoRedoMessage(files);
        return this.send(Commands.UNDO.create(data));
    }

    public JsonObject redo(List<String> files) throws IOException {
        if (!this.supports(Commands.REDO)) {
            throw new UnsupportedOperationByPluginException(Commands.REDO);
        }
        UndoRedoMessage data = new UndoRedoMessage(files);
        return this.send(Commands.REDO.create(data));
    }

    public JsonObject showInIde(String file, Integer line, Integer column) throws IOException {
        if (!this.supports(Commands.SHOW_IN_IDE)) {
            throw new UnsupportedOperationByPluginException(Commands.SHOW_IN_IDE);
        }
        ShowInIdeMessage data = new ShowInIdeMessage(file, line, column);
        return this.send(Commands.SHOW_IN_IDE.create(data));
    }

    public JsonObject refresh() throws IOException {
        if (!this.supports(Commands.REFRESH)) {
            throw new UnsupportedOperationByPluginException(Commands.REFRESH);
        }
        return this.send(Commands.REFRESH.create(new RefreshMessage()));
    }

    public boolean supports(Commands command) {
        return this.getProperties().getSupportedActions().contains(command.command);
    }

    private JsonObject send(Command command) {
        if (this.getProperties().getEndpoint() != null) {
            return this.sendRestSync(command);
        }
        this.sendSocket(command);
        return null;
    }

    private JsonObject sendRestSync(Command command) {
        try {
            RestCommand restCommand = new RestCommand(command.command, this.getProjectBasePath(), command.data);
            byte[] data = this.objectMapper.writeValueAsBytes((Object)restCommand);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getProperties().getEndpoint())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofByteArray(data)).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException(String.valueOf(response.statusCode()));
            }
            if (response.body() != null && !response.body().isEmpty()) {
                JsonObject responseJson = Json.parse((String)response.body());
                this.handleIdeNotifications(responseJson);
                return responseJson;
            }
        }
        catch (IOException e) {
            try {
                this.removeDotFile();
            }
            catch (IOException ex2) {
                CopilotIDEPlugin.getLogger().warn("Cannot remove Copilot plugin properties file", (Throwable)ex2);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private void sendSocket(Command command) {
        try (Selector selector = Selector.open();
             SocketChannel channel = SocketChannel.open();){
            channel.configureBlocking(false);
            channel.register(selector, 8);
            channel.connect(new InetSocketAddress(this.getProperties().getPort()));
            while (!Thread.interrupted() && selector.isOpen()) {
                selector.select(1000L);
                Iterator<SelectionKey> keys = selector.selectedKeys().iterator();
                while (keys.hasNext()) {
                    SelectionKey key = keys.next();
                    keys.remove();
                    if (!key.isValid()) continue;
                    if (key.isConnectable()) {
                        if (channel.isConnectionPending()) {
                            channel.finishConnect();
                        }
                        channel.configureBlocking(false);
                        channel.register(selector, 4);
                    }
                    if (!key.isWritable()) continue;
                    byte[] data = this.objectMapper.writeValueAsBytes((Object)command);
                    ByteBuffer buffer = ByteBuffer.wrap(data);
                    while (buffer.hasRemaining()) {
                        channel.write(buffer);
                    }
                    selector.close();
                }
            }
        }
        catch (IOException ex) {
            try {
                this.removeDotFile();
            }
            catch (IOException ex2) {
                CopilotIDEPlugin.getLogger().warn("Cannot remove Copilot plugin properties file", (Throwable)ex2);
            }
        }
    }

    public static String undoLabel(String operation) {
        return "Vaadin Copilot " + operation;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CopilotIDEPlugin.class);
    }

    private void handleIdeNotifications(JsonObject response) {
        if (response == null) {
            return;
        }
        if (response.get("blockingPopup") != null) {
            IdeNotification notification = new IdeNotification("There is a popup in your IDE waiting for action, please check because it might block next Vaadin Copilot operations", IdeNotification.Type.WARNING, "blocking-popup");
            devToolsInterface.send("copilot-ide-notification", notification.asJson());
            response.remove("blockingPopup");
        }
    }

    public static enum Commands {
        WRITE("write"),
        WRITE_BASE64("writeBase64"),
        UNDO("undo"),
        REDO("redo"),
        SHOW_IN_IDE("showInIde"),
        REFRESH("refresh");

        final String command;

        private Commands(String command) {
            this.command = command;
        }

        Command create(Object data) {
            return new Command(this.command, data);
        }
    }

    private static class UnsupportedOperationByPluginException
    extends UnsupportedOperationException {
        public UnsupportedOperationByPluginException(Commands command) {
            super("Used version of Copilot IDE Plugin does not support %s operation, please update plugin to latest version.".formatted(command.command));
        }
    }

    private record WriteFileMessage(String file, String undoLabel, String content) {
    }

    private record Command(String command, Object data) {
    }

    private record UndoRedoMessage(List<String> files) {
    }

    private record ShowInIdeMessage(String file, Integer line, Integer column) {
    }

    private record RefreshMessage() {
    }

    private record RestCommand(String command, String projectBasePath, Object data) {
    }
}

