/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.flow.shared.util.SharedUtil;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Util {
    private static final Pattern endsWithNumber = Pattern.compile("([0-9]+)$");

    public static String increaseTrailingNumber(String filename) {
        String[] parts = filename.split("\\.", 2);
        String base = parts[0];
        String extension = parts[1];
        Matcher matcher = endsWithNumber.matcher(base);
        if (matcher.find()) {
            return base.substring(0, matcher.start()) + (Integer.parseInt(matcher.group()) + 1) + "." + extension;
        }
        return base + "1." + extension;
    }

    public static File getSinglePackage(File javaSourceFolder) {
        File[] files = javaSourceFolder.listFiles();
        if (files == null || files.length == 0 || files.length > 1) {
            return javaSourceFolder;
        }
        return Util.getSinglePackage(files[0]);
    }

    public static String titleCase(String input) {
        return Arrays.stream(input.split(" ")).map(SharedUtil::capitalize).collect(Collectors.joining(" "));
    }
}

