/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.shared.util.SharedUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;

public final class FlowComponentQuirks {
    private static final String AVATAR_GROUP = "com.vaadin.flow.component.avatar.AvatarGroup";
    private static final String AVATAR_GROUP_ITEM = "com.vaadin.flow.component.avatar.AvatarGroup.AvatarGroupItem";
    private static final String MESSAGE_LIST = "com.vaadin.flow.component.messages.MessageList";
    private static final String MESSAGE_LIST_ITEM = "com.vaadin.flow.component.messages.MessageListItem";

    private FlowComponentQuirks() {
    }

    public static String getClassForTag(String tag) {
        String[] probes;
        if (tag.equalsIgnoreCase("A")) {
            tag = "Anchor";
        } else if (tag.equalsIgnoreCase("P")) {
            tag = "Paragraph";
        } else if (tag.equalsIgnoreCase("OL")) {
            tag = "OrderedList";
        } else if (tag.equalsIgnoreCase("ul")) {
            tag = "UnorderedList";
        } else if (tag.equalsIgnoreCase("dl")) {
            tag = "DescriptionList";
        } else if (tag.equalsIgnoreCase("dt")) {
            tag = "DescriptionList.Term";
        } else if (tag.equalsIgnoreCase("dd")) {
            tag = "DescriptionList.Description";
        } else if (tag.equalsIgnoreCase("LI")) {
            tag = "ListItem";
        } else if (tag.equalsIgnoreCase("img")) {
            tag = "Image";
        }
        String capitalizedTag = SharedUtil.capitalize((String)tag);
        String lowercaseTag = tag.toLowerCase(Locale.ENGLISH);
        String lowercaseFirstPart = FlowComponentQuirks.removeInitialDash(SharedUtil.camelCaseToDashSeparated((String)tag)).split("-", 2)[0].toLowerCase(Locale.ENGLISH);
        for (String probe : probes = new String[]{"com.vaadin.flow.component.html." + capitalizedTag, "com.vaadin.flow.component." + lowercaseTag + "." + capitalizedTag, "com.vaadin.flow.component." + lowercaseFirstPart + "." + capitalizedTag, "com.vaadin.flow.component.orderedlayout." + capitalizedTag, "com.vaadin.flow.component.messages." + capitalizedTag, "com.vaadin.flow.component.sidenav." + capitalizedTag, "com.vaadin.flow.component.textfield." + capitalizedTag, "com.vaadin.flow.component.combobox." + capitalizedTag, "com.vaadin.flow.component.applayout." + capitalizedTag, "com.vaadin.flow.component.charts." + capitalizedTag, "com.vaadin.flow.component.tabs." + capitalizedTag}) {
            if (!FlowComponentQuirks.exists(probe)) continue;
            return probe;
        }
        if (tag.equalsIgnoreCase("BoardRow")) {
            return "com.vaadin.flow.component.board.Row";
        }
        if (tag.equalsIgnoreCase("RadioGroup")) {
            return "com.vaadin.flow.component.radiobutton.RadioButtonGroup";
        }
        throw new IllegalArgumentException("Unable to find Java class for <" + tag + ">");
    }

    private static String removeInitialDash(String s) {
        if (s.startsWith("-")) {
            return s.substring(1);
        }
        return s;
    }

    private static boolean exists(String className) {
        try {
            JavaRewriterUtil.getClass(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object componentSpecificValueMapping(Class<?> componentType, String prop, Object value) {
        String itemType = FlowComponentQuirks.getListSetterType(componentType, prop);
        if (itemType != null) {
            return FlowComponentQuirks.mapToClass((List)value, itemType, null);
        }
        return value;
    }

    private static String getListSetterType(Class<?> componentType, String prop) {
        if (componentType.getName().equals(AVATAR_GROUP) && prop.equals("items")) {
            return AVATAR_GROUP_ITEM;
        }
        if (componentType.getName().equals(MESSAGE_LIST) && prop.equals("items")) {
            return MESSAGE_LIST_ITEM;
        }
        return null;
    }

    private static List<JavaComponent> mapToClass(List<Map<String, Object>> value, String itemClass, BiFunction<String, Object, Object> customMapper) {
        return value.stream().map(item -> {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (Map.Entry entry : item.entrySet()) {
                Object propValue = entry.getValue();
                if (customMapper != null) {
                    propValue = customMapper.apply((String)entry.getKey(), propValue);
                }
                props.put((String)entry.getKey(), propValue);
            }
            return new JavaComponent(null, itemClass, props, new ArrayList<JavaComponent>());
        }).toList();
    }

    public static String convertReactPropertyToJavaSetter(String property, Class<?> type) {
        if (property.equals("theme")) {
            if (JavaRewriterUtil.hasMethod(type, "setThemeName")) {
                return "setThemeName";
            }
            return "getElement().getThemeList().add";
        }
        String typeName = type.getName();
        if (property.equals("checked") && typeName.equals("com.vaadin.flow.component.checkbox.Checkbox")) {
            return "setValue";
        }
        if (property.equals("text") && (typeName.equals("com.vaadin.flow.component.tabs.Tab") || typeName.equals("com.vaadin.flow.component.sidenav.SideNavItem"))) {
            return "setLabel";
        }
        if (property.equals("summary") && typeName.equals("com.vaadin.flow.component.accordion.AccordionPanel")) {
            return "setSummaryText";
        }
        if (property.equals("img") && typeName.equals("com.vaadin.flow.component.avatar.Avatar")) {
            return "setImage";
        }
        if (property.equals("abbr") && typeName.equals("com.vaadin.flow.component.avatar.Avatar")) {
            return "setAbbreviation";
        }
        if (property.equals("nodrop") && typeName.equals("com.vaadin.flow.component.upload.Upload")) {
            return "setDropAllowed";
        }
        return null;
    }

    public static boolean isInvertedBoolean(String property, Class<?> type) {
        return property.equals("nodrop") && type.getName().equals("com.vaadin.flow.component.upload.Upload");
    }

    public static boolean isChildGeneratesLabelAndValueStmts(JavaComponent parent, JavaComponent child) {
        if ("ListBox".equals(parent.tag()) && "Item".equals(child.tag())) {
            return true;
        }
        if ("RadioGroup".equals(parent.tag()) && "RadioButton".equals(child.tag())) {
            return true;
        }
        return "CheckboxGroup".equals(parent.tag()) && "Checkbox".equals(child.tag());
    }
}

