/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class IdePluginCommandHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    private final CopilotIDEPlugin plugin;

    public IdePluginCommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.plugin = CopilotIDEPlugin.getInstance();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        try {
            if (command.equals("plugin-undo")) {
                if (this.plugin.isActive()) {
                    List<String> files = JsonUtils.stream((JsonArray)data.getArray("files")).map(JsonValue::asString).map(this::filter).toList();
                    this.plugin.undo(files);
                }
                return true;
            }
            if (command.equals("plugin-redo")) {
                if (this.plugin.isActive()) {
                    List<String> files = JsonUtils.stream((JsonArray)data.getArray("files")).map(JsonValue::asString).map(this::filter).toList();
                    this.plugin.redo(files);
                }
                return true;
            }
            if (command.equals("plugin-refresh") && this.plugin.isActive()) {
                this.plugin.refresh();
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Copilot Plugin operation failed", e);
        }
        return false;
    }

    private String filter(String filename) {
        Optional<File> themeFolder;
        if (filename.equals("$THEME_EDITOR_CSS") && (themeFolder = this.projectManager.getThemeFolder()).isPresent()) {
            return themeFolder.get().toPath().resolve("theme-editor.css").toString();
        }
        return filename;
    }
}

