/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.vaadin.copilot.JavaRewriteHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JavaBatchRewriter {
    private final ProjectManager projectManager;
    private final Map<File, JavaRewriter> rewriters = new HashMap<File, JavaRewriter>();
    private final Map<ComponentTypeAndSourceLocation, ComponentInfo> components;

    public JavaBatchRewriter(ProjectManager projectManager, List<ComponentTypeAndSourceLocation> componentLocations) {
        this.projectManager = projectManager;
        this.rewriters.putAll(componentLocations.stream().map(ComponentTypeAndSourceLocation::javaFile).distinct().collect(Collectors.toMap(file -> file, file -> {
            try {
                return new JavaRewriter(projectManager.readFile((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })));
        this.components = componentLocations.stream().distinct().collect(Collectors.toMap(component -> component, component -> {
            JavaRewriter rewriter = this.rewriters.get(component.javaFile());
            return rewriter.findComponentInfo((ComponentTypeAndSourceLocation)component);
        }));
        this.filterComponents(component -> ((ComponentInfo)component.getValue()).objectCreationExpr() != null);
    }

    private void filterComponents(Predicate<? super Map.Entry<ComponentTypeAndSourceLocation, ComponentInfo>> filter) {
        this.components.entrySet().removeIf(entry -> !filter.test((Map.Entry<ComponentTypeAndSourceLocation, ComponentInfo>)entry));
    }

    public void deleteAll() {
        this.forEachComponent((source, component, rewriter) -> component.rewriter().delete(component));
    }

    public void duplicate(ComponentTypeAndSourceLocation componentSource) {
        ComponentInfo component = this.components.get(componentSource);
        if (component == null) {
            throw new IllegalArgumentException("The component to be duplicated must be included in the " + this.getClass().getSimpleName() + " constructor call");
        }
        if (JavaRewriterUtil.isRouteClass(componentSource, component.rewriter().compilationUnit)) {
            throw new IllegalArgumentException("Routes cannot be duplicated.");
        }
        this.duplicateComponent(componentSource, component, true);
    }

    private JavaRewriter.DuplicateInfo duplicateComponent(ComponentTypeAndSourceLocation componentSource, ComponentInfo component, boolean attachIt) {
        JavaRewriter.DuplicateInfo result = component.rewriter().duplicate(component, attachIt);
        for (ComponentTypeAndSourceLocation child : componentSource.children()) {
            ComponentInfo childComponent = this.components.get(child);
            if (childComponent == null || childComponent.isAnonymousComponent()) continue;
            JavaRewriter.DuplicateInfo childResult = this.duplicateComponent(child, childComponent, false);
            for (Map.Entry<String, String> entry : childResult.nameMapping().entrySet()) {
                String oldName = entry.getKey();
                String newName = entry.getValue();
                result.childAddCalls().forEach(addCall -> component.rewriter().replaceCallParameter((NodeWithArguments<?>)addCall, oldName, newName));
                if (childComponent.attachCall().getObjectCreationExpression() == null) continue;
                if (result.variableDeclaration() != null && result.variableDeclaration().getVariables().isNonEmpty()) {
                    Expression vd = result.variableDeclaration().getVariable(0).getInitializer().orElse(null);
                    if (vd == null || !vd.isObjectCreationExpr()) continue;
                    component.rewriter().replaceCallParameter((NodeWithArguments<?>)vd.asObjectCreationExpr(), oldName, newName);
                    continue;
                }
                if (result.assignExpr() == null || result.assignExpr().getValue() == null || !result.assignExpr().getValue().isObjectCreationExpr()) continue;
                ObjectCreationExpr parentObjectCreationExpr = result.assignExpr().getValue().asObjectCreationExpr();
                component.rewriter().replaceCallParameter((NodeWithArguments<?>)parentObjectCreationExpr, oldName, newName);
            }
        }
        return result;
    }

    public void forEachComponent(Callback cb) {
        this.components.forEach((source, component) -> {
            JavaRewriter rewriter = this.rewriters.get(source.javaFile());
            cb.accept((ComponentTypeAndSourceLocation)source, (ComponentInfo)component, rewriter);
        });
    }

    public Map<File, String> getResults() {
        return this.rewriters.keySet().stream().collect(Collectors.toMap(file -> file, file -> this.rewriters.get(file).getResult()));
    }

    public void writeResult() {
        this.getResults().forEach((file, result) -> {
            try {
                this.projectManager.writeFile((File)file, JavaRewriteHandler.UNDO_LABEL, (String)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static interface Callback {
        public void accept(ComponentTypeAndSourceLocation var1, ComponentInfo var2, JavaRewriter var3);
    }
}

