/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaBatchRewriter;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaDataProviderHandler;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriteHandler
implements CopilotCommand {
    public static final String UNDO_LABEL = CopilotIDEPlugin.undoLabel("Java view update");
    private final ProjectManager projectManager;
    private final Map<String, RewriteHandler> handlers = new HashMap<String, RewriteHandler>();

    public JavaRewriteHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.handlers.put("set-component-property", new RewriteHandler("set component property", this::handleSetComponentProperty));
        this.handlers.put("add-call", new RewriteHandler("add call", this::handleAddCall));
        this.handlers.put("add-template", new RewriteHandler("add call", this::handleAddTemplate));
        this.handlers.put("delete-components", new RewriteHandler("delete components", this::handleDeleteComponents));
        this.handlers.put("duplicate-components", new RewriteHandler("duplicate components", this::handleDuplicateComponents));
        this.handlers.put("drag-and-drop", new RewriteHandler("drop component", this::handleDragAndDrop));
        this.handlers.put("set-alignment", new RewriteHandler("set alignment", this::handleAlignment));
        this.handlers.put("set-gap", new RewriteHandler("set gap", this::handleGap));
        this.handlers.put("wrap-with", new RewriteHandler("wrap with", data -> this.handleWrapWith(data)));
        this.handlers.put("set-styles", new RewriteHandler("set styles", this::handleSetStyles));
        this.handlers.put("set-padding", new RewriteHandler("set padding", this::handlePadding));
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        RewriteHandler handler = this.handlers.get(command);
        if (handler == null) {
            return false;
        }
        String reqId = data.getString("reqId");
        JsonObject respData = Json.createObject();
        respData.put("reqId", reqId);
        try {
            handler.handle(data);
            devToolsInterface.send(command + "-response", respData);
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to {} for input {}", new Object[]{handler.getWhat(), data.toJson(), e});
            ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Failed to " + handler.getWhat(), e);
        }
        return true;
    }

    private void handleAddCall(JsonObject data) throws IOException {
        String func = data.getString("func");
        String parameter = data.getString("parameter");
        Integer lineToShowInIde = data.hasKey("lineToShowInIde") ? Integer.valueOf((int)data.getNumber("lineToShowInIde")) : null;
        JsonObject component = data.getObject("component");
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.findTypeAndSourceLocation(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        if (!JavaRewriterUtil.hasSingleParameterMethod(info.type(), func)) {
            throw new IllegalArgumentException("Component does not support the given method");
        }
        rewriter.addCall(info, func, new JavaRewriter.Code(parameter));
        String result = rewriter.getResult();
        this.projectManager.writeFile(javaFile, UNDO_LABEL, result);
        if (lineToShowInIde != null) {
            int lineNumber = rewriter.getFirstModifiedRow() + lineToShowInIde;
            IdeUtils.openFile(javaFile, lineNumber);
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(1000L);
                    IdeUtils.openFile(javaFile, lineNumber);
                }
                catch (InterruptedException e) {
                    this.getLogger().error("Failed to show file in IDE", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private void handleDeleteComponents(JsonObject data) {
        JsonArray componentsJson = data.getArray("components");
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            List<ComponentTypeAndSourceLocation> found = this.findTypeAndSourceLocationIncludingChildren(componentsJson.getObject(i));
            components.addAll(found);
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, components);
        batchRewriter.deleteAll();
        batchRewriter.writeResult();
    }

    private List<ComponentTypeAndSourceLocation> findTypeAndSourceLocationIncludingChildren(JsonObject object) {
        ArrayList<ComponentTypeAndSourceLocation> all = new ArrayList<ComponentTypeAndSourceLocation>();
        ComponentTypeAndSourceLocation root = this.findTypeAndSourceLocation(object, true);
        this.addRecursively(all, root);
        return all;
    }

    private void addRecursively(ArrayList<ComponentTypeAndSourceLocation> all, ComponentTypeAndSourceLocation root) {
        all.add(root);
        for (ComponentTypeAndSourceLocation child : root.children()) {
            if (child.javaFile().exists()) {
                this.addRecursively(all, child);
                continue;
            }
            this.getLogger().debug("Excluding file {} because it does not exist. Assuming this is a component created internally by the parent component and not from the project source", (Object)child.javaFile());
        }
    }

    private void handleDuplicateComponents(JsonObject data) {
        JsonArray componentsJson = data.getArray("components");
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        ArrayList<ComponentTypeAndSourceLocation> selectedComponents = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            ComponentTypeAndSourceLocation root = this.findTypeAndSourceLocation(componentsJson.getObject(i), true);
            selectedComponents.add(root);
            this.addRecursively(components, root);
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, components);
        selectedComponents.forEach(batchRewriter::duplicate);
        batchRewriter.writeResult();
    }

    private void handleWrapWith(JsonObject data) throws IOException {
        JsonArray componentsJson = data.getArray("components");
        JavaComponent wrapperComponent = JavaComponent.componentFromJson(data.getObject("wrapperComponent"));
        ArrayList<ComponentTypeAndSourceLocation> components = new ArrayList<ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            components.add(this.findTypeAndSourceLocation(componentsJson.getObject(i)));
        }
        File javaFile = this.projectManager.getSourceFile(((ComponentTypeAndSourceLocation)components.get(0)).createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        List<ComponentInfo> componentInfos = components.stream().map(rewriter::findComponentInfo).toList();
        rewriter.mergeAndReplace(componentInfos, wrapperComponent);
        String result = rewriter.getResult();
        this.projectManager.writeFile(javaFile, UNDO_LABEL, result);
    }

    private void handleSetComponentProperty(JsonObject data) throws IOException {
        String property = data.getString("property");
        String value = data.getString("value");
        JsonObject component = data.getObject("component");
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.findTypeAndSourceLocation(component);
        if (JavaDataProviderHandler.isDataProviderItemChange(typeAndSourceLocation)) {
            JavaDataProviderHandler dataProviderHandler = new JavaDataProviderHandler(this.projectManager, typeAndSourceLocation);
            JavaDataProviderHandler.JavaDataProviderHandlerResult javaDataProviderHandlerResult = dataProviderHandler.handleSetComponentProperty(property, value);
            this.projectManager.writeFile(javaDataProviderHandlerResult.file(), UNDO_LABEL, javaDataProviderHandlerResult.result());
            return;
        }
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        String setter = JavaRewriterUtil.getSetterName(property, info.type(), true);
        rewriter.replaceFunctionCall(info, setter, value);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAddTemplate(JsonObject data) throws IOException {
        List<JavaComponent> template = JavaComponent.componentsFromJson(data.getArray("template"));
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation refSource = this.findTypeAndSourceLocation(data.getObject("refNode"));
        File javaFile = this.projectManager.getSourceFile(refSource.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo ref = rewriter.findComponentInfo(refSource);
        if (where == JavaRewriter.Where.APPEND) {
            rewriter.addComponentUsingTemplate(ref, where, template);
        } else {
            if (!refSource.parent().javaFile().equals(refSource.javaFile())) {
                throw new IllegalArgumentException("Cannot insert before a component in one file (" + String.valueOf(refSource.javaFile()) + ") when the parent is in another file (" + String.valueOf(refSource.parent().javaFile()) + ")");
            }
            rewriter.addComponentUsingTemplate(ref, where, template);
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleDragAndDrop(JsonObject data) throws IOException {
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation dragged = this.findTypeAndSourceLocation(data.getObject("dragged"));
        ComponentTypeAndSourceLocation container = this.findTypeAndSourceLocation(data.getObject("container"));
        ComponentTypeAndSourceLocation insertBefore = where == JavaRewriter.Where.BEFORE ? this.findTypeAndSourceLocation(data.getObject("insertBefore")) : null;
        File javaFile = this.projectManager.getSourceFile(container.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        if (!dragged.javaFile().equals(container.javaFile())) {
            throw new IllegalArgumentException("Cannot move a component in one file (" + String.valueOf(dragged.javaFile()) + ") to another file (" + String.valueOf(container.javaFile()) + ")");
        }
        ComponentInfo draggedRef = rewriter.findComponentInfo(dragged);
        ComponentInfo containerRef = rewriter.findComponentInfo(container);
        ComponentInfo insertBeforeRef = insertBefore == null ? null : rewriter.findComponentInfo(insertBefore);
        rewriter.moveComponent(draggedRef, containerRef, insertBeforeRef, where);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAlignment(JsonObject data) throws IOException {
        JavaRewriter.AlignmentMode mode = JavaRewriter.AlignmentMode.valueOf(data.getString("alignmentMode").replace('-', '_').toUpperCase(Locale.ENGLISH));
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.findTypeAndSourceLocation(data.getObject("componentId"));
        JsonArray lumoClassesJson = data.getArray("lumoClasses");
        ArrayList<String> lumoClasses = new ArrayList<String>();
        for (int i = 0; i < lumoClassesJson.length(); ++i) {
            lumoClasses.add(lumoClassesJson.getString(i));
        }
        boolean selected = data.getBoolean("selected");
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setAlignment(componentInfo, mode, selected, lumoClasses);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleSetStyles(JsonObject data) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.findTypeAndSourceLocation(data.getObject("componentId"));
        JsonArray added = data.getArray("added");
        JsonArray removed = data.getArray("removed");
        HashSet<String> toRemove = new HashSet<String>();
        for (int i = 0; i < removed.length(); ++i) {
            toRemove.add(removed.getObject(i).getString("key"));
        }
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        for (int i = 0; i < added.length(); ++i) {
            JsonObject rule = added.getObject(i);
            String key = rule.getString("key");
            String value = rule.getString("value");
            rewriter.setStyle(componentInfo, key, value);
            toRemove.remove(key);
        }
        for (String key : toRemove) {
            rewriter.setStyle(componentInfo, key, null);
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleGap(JsonObject data) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.findTypeAndSourceLocation(data.getObject("componentId"));
        String newValue = data.getString("newValue");
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setGap(componentInfo, newValue);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handlePadding(JsonObject data) throws IOException {
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.findTypeAndSourceLocation(data.getObject("componentId"));
        String newClassName = data.hasKey("newClassName") ? data.getString("newClassName") : null;
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setPadding(componentInfo, newClassName);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component) {
        return this.findTypeAndSourceLocation(component, false);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component, boolean includeChildren) {
        VaadinSession session = VaadinSession.getCurrent();
        AtomicReference<Object> info = new AtomicReference<Object>(null);
        session.accessSynchronously((Command & Serializable)() -> {
            Element element = session.findElement((int)component.getNumber("uiId"), (int)component.getNumber("nodeId"));
            Optional c = element.getComponent();
            if (c.isPresent()) {
                ComponentTypeAndSourceLocation componentInfo = this.findTypeAndSourceLocation((Component)c.get(), includeChildren);
                info.set(componentInfo);
            }
        });
        ComponentTypeAndSourceLocation res = info.get();
        if (res == null) {
            throw new IllegalArgumentException("Unable to find component in source");
        }
        return res;
    }

    private ComponentTypeAndSourceLocation findTypeAndSourceLocation(Component c, boolean includeChildren) {
        Optional parent = c.getParent();
        ComponentTypeAndSourceLocation parentInfo = parent.map(p -> this.getSourceLocation((Component)p, null, null)).orElse(null);
        ArrayList<ComponentTypeAndSourceLocation> children = new ArrayList<ComponentTypeAndSourceLocation>();
        if (includeChildren) {
            c.getChildren().forEach(child -> {
                ComponentTypeAndSourceLocation childInfo = this.findTypeAndSourceLocation((Component)child, true);
                children.add(childInfo);
            });
        }
        return this.getSourceLocation(c, parentInfo, children);
    }

    private ComponentTypeAndSourceLocation getSourceLocation(Component component, ComponentTypeAndSourceLocation parentInfo, List<ComponentTypeAndSourceLocation> children) {
        ComponentTracker.Location createLocation = ComponentTracker.findCreate((Component)component);
        ComponentTracker.Location attachLocation = ComponentTracker.findAttach((Component)component);
        File javaFile = this.projectManager.getSourceFile(createLocation);
        ArrayList<Class> inheritanceChain = new ArrayList<Class>();
        inheritanceChain.add(component.getClass());
        for (Class<?> superClass = component.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            inheritanceChain.add(superClass);
        }
        return new ComponentTypeAndSourceLocation(component.getClass(), inheritanceChain, component, javaFile, createLocation, attachLocation, parentInfo, children);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private static class RewriteHandler {
        private final String what;
        private final Handler handler;

        public RewriteHandler(String what, Handler handler) {
            this.what = what;
            this.handler = handler;
        }

        public void handle(JsonObject data) throws IOException {
            this.handler.handle(data);
        }

        public String getWhat() {
            return this.what;
        }
    }

    private static interface Handler {
        public void handle(JsonObject var1) throws IOException;
    }
}

