/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.plugins.themeeditor.JavaSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.ThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.handlers.ClassNameHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.ComponentMetadataHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LoadPreviewHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LoadRulesHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LocalClassNameHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.OpenCssHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.RulesHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.SetFontHandler;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.ErrorResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.ThemeNotFoundError;
import com.vaadin.copilot.plugins.themeeditor.utils.HasSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeEditorMessageHandler
implements HasSourceModifier,
HasThemeModifier,
CopilotCommand {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JavaSourceModifier sourceModifier;
    private final ThemeModifier themeModifier;
    private final Set<MessageHandler> handlers = new HashSet<MessageHandler>();
    private boolean missingThemeNotificationSent = false;

    public ThemeEditorMessageHandler(ProjectManager projectManager) {
        this.sourceModifier = new JavaSourceModifier(projectManager);
        ThemeModifier modifier = null;
        if (projectManager.getThemeFolder().isPresent()) {
            modifier = new ThemeModifier(projectManager);
            this.registerHandlers();
        }
        this.themeModifier = modifier;
    }

    @Override
    public JavaSourceModifier getSourceModifier() {
        return this.sourceModifier;
    }

    @Override
    public ThemeModifier getThemeModifier() {
        return this.themeModifier;
    }

    public boolean canHandle(String command, JsonObject data) {
        return !this.missingThemeNotificationSent && command != null && data != null && data.hasKey("reqId") && this.getHandler(command).isPresent();
    }

    public BaseResponse handleDebugMessageData(String command, JsonObject data) {
        String requestId = data.getString("reqId");
        try {
            BaseResponse response = this.getHandler(command).map(h -> h.handle(data)).orElseGet(ErrorResponse::new);
            response.setReqId(requestId);
            return response;
        }
        catch (ThemeEditorException ex) {
            ThemeEditorMessageHandler.getLogger().debug(ex.getMessage(), (Throwable)ex);
            return new ErrorResponse(requestId, ex.getMessage());
        }
    }

    private ErrorResponse themeNotFoundError(JsonObject data) {
        String requestId = data.getString("reqId");
        return new ThemeNotFoundError(requestId);
    }

    private Optional<MessageHandler> getHandler(String command) {
        return this.handlers.stream().filter(h -> h.getCommandName().equals(command)).findFirst();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ThemeEditorMessageHandler.class.getName());
    }

    protected void registerHandlers() {
        this.handlers.add(new ComponentMetadataHandler(this));
        this.handlers.add(new RulesHandler(this));
        this.handlers.add(new LocalClassNameHandler(this, this));
        this.handlers.add(new LoadRulesHandler(this));
        this.handlers.add(new LoadPreviewHandler(this));
        this.handlers.add(new OpenCssHandler(this));
        this.handlers.add(new ClassNameHandler(this));
        this.handlers.add(new SetFontHandler(this));
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!data.hasKey("reqId")) {
            return false;
        }
        if (this.themeModifier == null && !this.missingThemeNotificationSent) {
            devToolsInterface.send(ThemeEditorCommand.RESPONSE.getValue(), this.toJsonObject(this.themeNotFoundError(data)));
            this.missingThemeNotificationSent = true;
            return true;
        }
        if (!this.canHandle(command, data)) {
            return false;
        }
        BaseResponse resultData = this.handleDebugMessageData(command, data);
        devToolsInterface.send(ThemeEditorCommand.RESPONSE.getValue(), this.toJsonObject(resultData));
        return true;
    }

    private JsonObject toJsonObject(Object object) {
        try {
            String resultAsString = this.objectMapper.writeValueAsString(object);
            return Json.parse((String)resultAsString);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

