/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.util.SharedUtil;
import java.util.Collections;
import java.util.List;

public class JavaStyleRewriter {
    public static List<StyleInfo> getStyles(ComponentInfo componentInfo) {
        return JavaRewriterUtil.findCalls(Style.class, componentInfo).stream().map(JavaStyleRewriter::extractStyle).toList();
    }

    public static void setStyle(ComponentInfo componentInfo, String dashSeparatedProperty, String value) {
        List<MethodCallExpr> styleCalls = JavaRewriterUtil.findCalls(Style.class, componentInfo);
        List<MethodCallExpr> existingSetters = styleCalls.stream().filter(methodCallExpr -> {
            StyleInfo style = JavaStyleRewriter.extractStyle(methodCallExpr);
            if (style.isDashSeparatedProperty) {
                return style.property().equals(dashSeparatedProperty);
            }
            return SharedUtil.camelCaseToDashSeparated((String)style.property()).equals(dashSeparatedProperty);
        }).toList();
        if (existingSetters.isEmpty()) {
            if (value == null) {
                throw new IllegalArgumentException("Unable to remove non-existing style " + dashSeparatedProperty + " from " + String.valueOf(componentInfo));
            }
            MethodCallExpr newStylesCall = JavaStyleRewriter.createStylesCall(dashSeparatedProperty, value);
            if (!styleCalls.isEmpty()) {
                MethodCallExpr lastStylesCall = styleCalls.get(styleCalls.size() - 1);
                JavaRewriterUtil.findAncestorOrThrow((Node)lastStylesCall, ExpressionStmt.class).setExpression((Expression)newStylesCall);
                newStylesCall.setScope((Expression)lastStylesCall);
            } else {
                MethodCallExpr getStyleCall = JavaRewriterUtil.addFunctionCall(componentInfo, "getStyle", Collections.emptyList());
                newStylesCall.setScope((Expression)JavaRewriterUtil.clone(getStyleCall));
                getStyleCall.replace((Node)newStylesCall);
            }
        } else {
            JavaStyleRewriter.updateStyle(existingSetters.get(existingSetters.size() - 1), value);
        }
    }

    private static MethodCallExpr createStylesCall(String dashSeparatedProperty, String value) {
        String camelCaseProperty = SharedUtil.dashSeparatedToCamelCase((String)dashSeparatedProperty);
        String setter = JavaRewriterUtil.getSetterName(camelCaseProperty, Style.class, false);
        if (JavaRewriterUtil.hasSetterForType(Style.class, setter, String.class)) {
            return (MethodCallExpr)new MethodCallExpr(null, setter).addArgument(JavaRewriterUtil.toExpression(value));
        }
        return (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(null, "set").addArgument(JavaRewriterUtil.toExpression(dashSeparatedProperty))).addArgument(JavaRewriterUtil.toExpression(value));
    }

    private static StyleInfo extractStyle(MethodCallExpr methodCallExpr) {
        String value;
        String setter = methodCallExpr.getNameAsString();
        if (setter.equals("set")) {
            String dashProperty = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(0), null));
            String value2 = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(1), null));
            return new StyleInfo(dashProperty, value2, true);
        }
        int argCount = methodCallExpr.getArguments().size();
        if (argCount != 1) {
            throw new IllegalArgumentException("Expected styles method call expression to have one argument but was " + argCount + " for " + String.valueOf(methodCallExpr));
        }
        Expression argument = methodCallExpr.getArgument(0);
        if (argument.isFieldAccessExpr()) {
            String fieldName = argument.asFieldAccessExpr().getNameAsString();
            value = fieldName.replace("_", "-").toLowerCase();
        } else if (argument.isStringLiteralExpr()) {
            value = argument.asStringLiteralExpr().getValue();
        } else {
            throw new IllegalArgumentException("Unexpected argument type in style call: " + String.valueOf(methodCallExpr));
        }
        String property = JavaRewriterUtil.getPropertyName(setter);
        return new StyleInfo(property, value, false);
    }

    static void updateStyle(MethodCallExpr methodCallExpr, Object value) {
        if (value == null) {
            JavaRewriterUtil.removeFromChainedStyleCall(methodCallExpr);
            return;
        }
        if (methodCallExpr.getNameAsString().equals("set")) {
            methodCallExpr.getArgument(1).replace((Node)JavaRewriterUtil.toExpression(value));
        } else {
            methodCallExpr.getArgument(0).replace((Node)JavaRewriterUtil.toExpression(value));
        }
    }

    public record StyleInfo(String property, String value, boolean isDashSeparatedProperty) {
    }
}

