/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.Map;
import java.util.Optional;

public class DataEntityRecordRewriter {
    public static final String DEFAULT_ENTITY_RECORD_NAME = "DataEntity";
    private final CompilationUnit compilationUnit;

    public DataEntityRecordRewriter(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public String addOrGetDataEntityRecordName(Map<String, Object> entityFields, String dataEntityRecordName) {
        return this.addDataEntityRecord(entityFields, dataEntityRecordName);
    }

    private String addDataEntityRecord(Map<String, Object> entityFields, String dataEntityRecordName) {
        RecordDeclaration recordDeclaration = new RecordDeclaration();
        recordDeclaration.setPublic(true);
        recordDeclaration.setName(dataEntityRecordName);
        NodeList params = new NodeList();
        NodeList args = new NodeList();
        for (Map.Entry<String, Object> entry : entityFields.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("children")) continue;
            Parameter param = new Parameter();
            param.setType(entry.getValue().getClass().getSimpleName());
            param.setName(entry.getKey());
            recordDeclaration.addParameter(param);
            params.add((Node)param);
            args.add((Node)new NameExpr(entry.getKey()));
        }
        Optional classOptional = this.compilationUnit.findFirst(ClassOrInterfaceDeclaration.class);
        if (classOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find the class to add record");
        }
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)classOptional.get();
        classOrInterfaceDeclaration.getMembers().add((Node)recordDeclaration);
        return dataEntityRecordName;
    }
}

