/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.FlowUtil;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IdePluginCommandHandler
implements CopilotCommand {
    private static final String UI_ID = "uiId";
    private final ProjectManager projectManager;
    private final CopilotIDEPlugin plugin;

    public IdePluginCommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.plugin = CopilotIDEPlugin.getInstance();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        try {
            if (command.equals("plugin-undo")) {
                if (this.plugin.isActive() && this.plugin.supports(CopilotIDEPlugin.Commands.UNDO)) {
                    int flowUiId;
                    ArrayList<String> files = new ArrayList<String>();
                    files.addAll(JsonUtils.stream((JsonArray)data.getArray("files")).map(JsonValue::asString).map(this::filter).toList());
                    if (data.hasKey(UI_ID) && (flowUiId = (int)data.getNumber(UI_ID)) >= 0) {
                        Map<ComponentTracker.Location, File> flowFiles = FlowUtil.findActiveJavaFiles(flowUiId);
                        files.addAll(flowFiles.values().stream().map(File::getAbsolutePath).toList());
                    }
                    this.plugin.undo(files);
                }
                return true;
            }
            if (command.equals("plugin-redo")) {
                if (this.plugin.isActive() && this.plugin.supports(CopilotIDEPlugin.Commands.REDO)) {
                    List<String> files = JsonUtils.stream((JsonArray)data.getArray("files")).map(JsonValue::asString).map(this::filter).toList();
                    this.plugin.redo(files);
                }
                return true;
            }
            if (command.equals("plugin-refresh") && this.plugin.supports(CopilotIDEPlugin.Commands.REFRESH) && this.plugin.isActive()) {
                this.plugin.refresh();
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Copilot Plugin operation failed", e);
        }
        return false;
    }

    private String filter(String filename) {
        Optional<File> themeFolder;
        if (filename.equals("$THEME_EDITOR_CSS") && (themeFolder = this.projectManager.getThemeFolder()).isPresent()) {
            return themeFolder.get().toPath().resolve("theme-editor.css").toString();
        }
        return filename;
    }
}

