/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.vaadin.copilot.JavaRewriteHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JavaBatchRewriter {
    private final ProjectManager projectManager;
    private final Map<File, JavaRewriter> rewriters = new HashMap<File, JavaRewriter>();
    private final Map<JavaRewriter.ComponentTypeAndSourceLocation, JavaRewriter.ComponentInfo> components;

    public JavaBatchRewriter(ProjectManager projectManager, List<JavaRewriter.ComponentTypeAndSourceLocation> componentLocations) {
        this.projectManager = projectManager;
        this.rewriters.putAll(componentLocations.stream().map(JavaRewriter.ComponentTypeAndSourceLocation::javaFile).distinct().collect(Collectors.toMap(file -> file, file -> {
            try {
                return new JavaRewriter(projectManager.readFile((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })));
        this.components = componentLocations.stream().collect(Collectors.toMap(component -> component, component -> {
            JavaRewriter rewriter = this.rewriters.get(component.javaFile());
            return rewriter.findComponentInfo((JavaRewriter.ComponentTypeAndSourceLocation)component);
        }));
    }

    public void deleteAll() {
        this.forEachComponent((source, component, rewriter) -> component.rewriter().delete(component));
    }

    public void forEachComponent(Callback cb) {
        this.components.forEach((source, component) -> {
            JavaRewriter rewriter = this.rewriters.get(source.javaFile());
            cb.accept((JavaRewriter.ComponentTypeAndSourceLocation)source, (JavaRewriter.ComponentInfo)component, rewriter);
        });
    }

    public Map<File, String> getResults() {
        return this.rewriters.keySet().stream().collect(Collectors.toMap(file -> file, file -> this.rewriters.get(file).getResult()));
    }

    public void writeResult() {
        this.getResults().forEach((file, result) -> {
            try {
                this.projectManager.writeFile((File)file, JavaRewriteHandler.UNDO_LABEL, (String)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static interface Callback {
        public void accept(JavaRewriter.ComponentTypeAndSourceLocation var1, JavaRewriter.ComponentInfo var2, JavaRewriter var3);
    }
}

