package com.vaadin.copilot;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class ProjectManager {
    private final Path projectRoot;

    public ProjectManager(Path projectRoot) throws IOException {
        this.projectRoot = projectRoot.toRealPath();
    }

    public String readFile(String filename) throws IOException {
        File file = new File(filename);
        if (isFileInsideProject(file)) {
            return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        } else {
            throw new IllegalArgumentException("File " + filename
                    + " is not inside the project at " + projectRoot);
        }
    }

    boolean isFileInsideProject(File file) throws IOException {
        Path path = getRealPath(file);
        return (path.startsWith(projectRoot));
    }

    private Path getRealPath(File file) throws IOException {
        Path path = file.toPath();
        try {
            return path.toRealPath();
        } catch (NoSuchFileException e) {
            // As we allow creating new files, we check the directory instead
            return path.getParent().toRealPath().resolve(path.getFileName());
        }
    }

    public void writeFile(String filename, String content) throws IOException {
        File file = new File(filename);
        if (isFileInsideProject(file)) {
            FileUtils.write(new File(filename), content,
                    StandardCharsets.UTF_8);
        } else {
            throw new IllegalArgumentException("File " + filename
                    + " is not inside the project at " + projectRoot);
        }
    }

}
