/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.RulesRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.CssRule;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RulesHandler
implements MessageHandler {
    private final HasThemeModifier hasThemeModifier;

    public RulesHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        RulesRequest request = (RulesRequest)JsonUtils.readToObject((JsonObject)data, RulesRequest.class);
        ArrayList<CssRule> rules = new ArrayList<CssRule>(request.getRules());
        List<String> selectors = request.getRules().stream().map(CssRule::getSelector).collect(Collectors.toList());
        this.hasThemeModifier.getThemeModifier().ensureFilesExist();
        ArrayList<CssRule> currentRules = new ArrayList<CssRule>();
        for (CssRule rule : rules) {
            List<CssRule> existingRules = this.hasThemeModifier.getThemeModifier().getCssRules(selectors);
            if (!existingRules.isEmpty()) {
                currentRules.add(this.buildUndoRule(rule, existingRules.get(0)));
                continue;
            }
            currentRules.add(this.buildRuleWithEmptyValues(rule));
        }
        return new MessageHandler.ExecuteAndUndo(() -> {
            this.hasThemeModifier.getThemeModifier().setThemeProperties(rules);
            return BaseResponse.ok();
        }, Optional.of(() -> {
            this.hasThemeModifier.getThemeModifier().setThemeProperties(currentRules);
            return BaseResponse.ok();
        }));
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.RULES.getValue();
    }

    private CssRule buildUndoRule(CssRule newRule, CssRule existingRule) {
        HashMap<String, String> properties = new HashMap<String, String>();
        newRule.getProperties().forEach((k, v) -> properties.put((String)k, existingRule.getProperties().get(k)));
        CssRule undoRule = newRule.clone();
        undoRule.setProperties(properties);
        return undoRule;
    }

    private CssRule buildRuleWithEmptyValues(CssRule rule) {
        HashMap<String, String> properties = new HashMap<String, String>();
        rule.getProperties().forEach((k, v) -> properties.put((String)k, ""));
        CssRule emptyRule = rule.clone();
        emptyRule.setProperties(properties);
        return emptyRule;
    }
}

