/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.copilot.plugins.themeeditor.JavaSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.ThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.handlers.ClassNameHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.ComponentMetadataHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.HistoryHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LoadPreviewHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LoadRulesHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.LocalClassNameHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.OpenCssHandler;
import com.vaadin.copilot.plugins.themeeditor.handlers.RulesHandler;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.ErrorResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.StateMessage;
import com.vaadin.copilot.plugins.themeeditor.utils.HasSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorHistory;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeEditorMessageHandler
implements HasSourceModifier,
HasThemeModifier,
DevToolsMessageHandler {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private JavaSourceModifier sourceModifier;
    private ThemeModifier themeModifier;
    private final Set<MessageHandler> handlers = new HashSet<MessageHandler>();

    public boolean isEnabled() {
        return this.getThemeModifier().isEnabled();
    }

    public StateMessage getStateMessage() {
        return new StateMessage(this.getThemeModifier().getState().name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public JavaSourceModifier getSourceModifier() {
        return this.sourceModifier;
    }

    @Override
    public ThemeModifier getThemeModifier() {
        return this.themeModifier;
    }

    public boolean canHandle(String command, JsonObject data) {
        return command != null && data != null && data.hasKey("requestId") && this.getHandler(command).isPresent();
    }

    public BaseResponse handleDebugMessageData(String command, JsonObject data) {
        assert (this.canHandle(command, data));
        String requestId = data.getString("requestId");
        Integer uiId = (int)data.getNumber("uiId");
        ThemeEditorHistory history = ThemeEditorHistory.forUi(uiId);
        try {
            MessageHandler.ExecuteAndUndo executeAndUndo = this.getHandler(command).get().handle(data);
            executeAndUndo.undoCommand().ifPresent(undo -> history.put(requestId, executeAndUndo));
            BaseResponse response = executeAndUndo.executeCommand().execute();
            response.setRequestId(requestId);
            return response;
        }
        catch (ThemeEditorException ex) {
            ThemeEditorMessageHandler.getLogger().error(ex.getMessage(), (Throwable)ex);
            return new ErrorResponse(requestId, ex.getMessage());
        }
    }

    private Optional<MessageHandler> getHandler(String command) {
        return this.handlers.stream().filter(h -> h.getCommandName().equals(command)).findFirst();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ThemeEditorMessageHandler.class.getName());
    }

    protected void registerHandlers() {
        this.handlers.add(new ComponentMetadataHandler(this));
        this.handlers.add(new RulesHandler(this));
        this.handlers.add(new LocalClassNameHandler(this, this));
        this.handlers.add(new HistoryHandler());
        this.handlers.add(new LoadRulesHandler(this));
        this.handlers.add(new LoadPreviewHandler(this));
        this.handlers.add(new OpenCssHandler(this));
        this.handlers.add(new ClassNameHandler(this));
    }

    public void handleConnect(DevToolsInterface devToolsInterface) {
        VaadinContext context = VaadinService.getCurrent().getContext();
        this.sourceModifier = new JavaSourceModifier(context);
        this.themeModifier = new ThemeModifier(context);
        if (this.isEnabled()) {
            devToolsInterface.send(ThemeEditorCommand.STATE.getValue(), this.toJsonObject(this.getStateMessage()));
            this.registerHandlers();
        }
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (this.isEnabled() && !this.canHandle(command, data)) {
            return false;
        }
        BaseResponse resultData = this.handleDebugMessageData(command, data);
        devToolsInterface.send(ThemeEditorCommand.RESPONSE.getValue(), this.toJsonObject(resultData));
        return true;
    }

    private JsonObject toJsonObject(Object object) {
        try {
            String resultAsString = this.objectMapper.writeValueAsString(object);
            return Json.parse((String)resultAsString);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

