package com.vaadin.copilot.analytics;

import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.UserInfoHandler;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * Client for tracking features of Copilot
 */
public class AnalyticsClient extends CopilotServerClient {

    private final ProKey proKey;

    private final String machineId;

    private Boolean isVaadiner;

    /**
     * Constructor loading ProKey
     */
    public AnalyticsClient() {
        this.proKey = LocalProKey.get();
        this.machineId = MachineId.get();
        try {
            LicenseChecker.checkLicense(UserInfoHandler.PRODUCT_VAADIN_EMPLOYEE,
                    "1.0.0", BuildType.DEVELOPMENT, url -> {
                        // Do not ask the user to log in
                    });
            this.isVaadiner = Boolean.TRUE;
        } catch (LicenseException e) {
            this.isVaadiner = Boolean.FALSE;
        }
    }

    /**
     * Track event to copilot-server
     *
     * @param event
     *            Event name
     * @param properties
     *            Map of event properties
     */
    public void track(String event, Map<String, String> properties,
            Map<String, String> context) {
        properties = properties == null ? new HashMap<>()
                : new HashMap<>(properties);
        properties.put("Vaadiner", isVaadiner.toString());
        sendRequest(event, properties, context);
    }

    protected void sendRequest(String event, Map<String, String> properties,
            Map<String, String> context) {
        URI uri = getQueryURI("analytics");
        AnalyticsRequest trackingRequest = new AnalyticsRequest(
                proKey != null ? proKey.getProKey() : null, machineId, event,
                properties, context);
        String json = writeAsJsonString(trackingRequest);
        HttpRequest request = buildRequest(uri, json);
        getHttpClient().sendAsync(request,
                HttpResponse.BodyHandlers.ofString());
    }

}
