/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.AbstractCollaborationManager;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.CollaborationMessage;
import com.vaadin.collaborationengine.CollaborationMessagePersister;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.ListChangeEvent;
import com.vaadin.collaborationengine.ListKey;
import com.vaadin.collaborationengine.ListOperation;
import com.vaadin.collaborationengine.ListOperationResult;
import com.vaadin.collaborationengine.MessageHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageManager
extends AbstractCollaborationManager {
    private static final Object FETCH_LOCK;
    private static final String MISSING_RECENT_MESSAGES = "The messages returned invoking CollaborationMessagePersister.fetchMessages() do not include the last fetched message of the previous call. Please update the implementation to fetch all messages whose timestamp is greater OR EQUAL with the query's timestamp.";
    static final String LIST_NAME;
    private final CollaborationMessagePersister persister;
    private CollaborationList list;
    private MessageHandler messageHandler;
    private CollaborationMessage lastSeenMessage;
    private ListKey lastMessageKey;
    private boolean catchupMode = false;
    private final Map<CompletableFuture<Void>, CollaborationMessage> pendingMessageFutures = new LinkedHashMap<CompletableFuture<Void>, CollaborationMessage>();
    private final Map<CollaborationMessage, CompletableFuture<Void>> persistedMessageFutures = new LinkedHashMap<CollaborationMessage, CompletableFuture<Void>>();

    public MessageManager(Component component, UserInfo localUser, String topicId) {
        this(component, localUser, topicId, null);
    }

    public MessageManager(Component component, UserInfo localUser, String topicId, CollaborationMessagePersister persister) {
        this(new ComponentConnectionContext(component), localUser, topicId, persister, CollaborationEngine.getInstance());
    }

    public MessageManager(ConnectionContext context, UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        this(context, localUser, topicId, null, collaborationEngine);
    }

    public MessageManager(ConnectionContext context, UserInfo localUser, String topicId, CollaborationMessagePersister persister, CollaborationEngine collaborationEngine) {
        super(localUser, topicId, collaborationEngine);
        this.persister = persister;
        this.openTopicConnection(context, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
    }

    public void setMessageHandler(MessageHandler handler) {
        this.messageHandler = handler;
        this.lastSeenMessage = null;
        this.catchupMode = false;
        if (this.messageHandler != null) {
            this.getMessages().forEach(this::applyHandler);
        }
    }

    public CompletableFuture<Void> submit(String text) {
        Objects.requireNonNull(text);
        UserInfo user = this.getLocalUser();
        Instant now = this.getCollaborationEngine().getClock().instant();
        CollaborationMessage message = new CollaborationMessage(user, text, now);
        return this.submit(message);
    }

    public CompletableFuture<Void> submit(CollaborationMessage message) {
        Objects.requireNonNull(message);
        if (this.list == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.pendingMessageFutures.put(future, message);
            return future;
        }
        return this.appendOrPersist(message);
    }

    private CompletableFuture<Void> appendOrPersist(CollaborationMessage message) {
        if (this.persister != null) {
            String topicId = this.getTopicId();
            CollaborationMessagePersister.PersistRequest request = new CollaborationMessagePersister.PersistRequest(this, topicId, message);
            this.persister.persistMessage(request);
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.persistedMessageFutures.put(message, future);
            this.fetchPersistedList();
            return future;
        }
        return this.list.insertLast(message).getCompletableFuture();
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.list = topicConnection.getNamedList(LIST_NAME);
        this.list.subscribe(this::onListChange);
        this.fetchPersistedList();
        this.pendingMessageFutures.entrySet().removeIf(entry -> {
            CompletableFuture future = (CompletableFuture)entry.getKey();
            CollaborationMessage message = (CollaborationMessage)entry.getValue();
            this.appendOrPersist(message).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(result);
                }
            });
            return true;
        });
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        this.list = null;
        this.catchupMode = true;
    }

    private void onListChange(ListChangeEvent event) {
        CollaborationMessage message = event.getValue(CollaborationMessage.class);
        this.lastMessageKey = event.getKey();
        if (message != null) {
            CompletableFuture<Void> future = this.persistedMessageFutures.remove(message);
            if (future != null) {
                future.complete(null);
            }
            this.applyHandler(message);
        }
    }

    private void applyHandler(CollaborationMessage message) {
        if (!this.catchupMode) {
            this.lastSeenMessage = message;
            if (this.messageHandler != null) {
                DefaultMessageContext context = new DefaultMessageContext(message);
                this.messageHandler.handleMessage(context);
            }
        } else if (message.equals(this.lastSeenMessage)) {
            this.catchupMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchPersistedList() {
        if (this.persister != null && this.list != null) {
            String topicId = this.getTopicId();
            Object object = FETCH_LOCK;
            synchronized (object) {
                List<CollaborationMessage> recentMessages = this.getRecentMessages();
                Instant since = recentMessages.isEmpty() ? Instant.EPOCH : recentMessages.get(0).getTime();
                CollaborationMessagePersister.FetchQuery query = new CollaborationMessagePersister.FetchQuery(this, topicId, since);
                List<CollaborationMessage> messages = this.persister.fetchMessages(query).sorted(Comparator.comparing(CollaborationMessage::getTime)).filter(message -> !recentMessages.remove(message)).collect(Collectors.toList());
                if (!recentMessages.isEmpty()) {
                    throw new IllegalStateException(MISSING_RECENT_MESSAGES);
                }
                if (!messages.isEmpty()) {
                    query.throwIfPropsNotUsed();
                    this.insertPersistedMessages(messages);
                }
            }
        }
    }

    private void insertPersistedMessages(List<CollaborationMessage> messages) {
        ListKey ifLast = this.lastMessageKey;
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (CollaborationMessage message : messages) {
            ListOperation op = ListOperation.insertLast(message);
            if (ifLast != null) {
                op.ifLast(ifLast);
            } else {
                op.ifEmpty();
            }
            ListOperationResult<Boolean> insert = this.list.apply(op);
            futures.add(insert.getCompletableFuture());
            ifLast = insert.getKey();
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenAccept(result -> this.fetchPersistedList());
    }

    private List<CollaborationMessage> getRecentMessages() {
        List messages = this.getMessages().collect(Collectors.toList());
        CollaborationMessage lastMessage = messages.isEmpty() ? null : (CollaborationMessage)messages.get(messages.size() - 1);
        ArrayList<CollaborationMessage> recentMessages = new ArrayList<CollaborationMessage>();
        if (lastMessage != null) {
            CollaborationMessage m;
            Instant lastMessageTime = lastMessage.getTime();
            for (int i = messages.size() - 1; i >= 0 && (m = (CollaborationMessage)messages.get(i)).getTime().equals(lastMessageTime); --i) {
                recentMessages.add(m);
            }
        }
        return recentMessages;
    }

    Stream<CollaborationMessage> getMessages() {
        if (this.list != null) {
            return this.list.getItems(CollaborationMessage.class).stream();
        }
        return Stream.empty();
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/MessageManager", (String)"5.3");
        FETCH_LOCK = new Object();
        LIST_NAME = MessageManager.class.getName();
    }

    static class DefaultMessageContext
    implements MessageHandler.MessageContext {
        private final CollaborationMessage message;

        public DefaultMessageContext(CollaborationMessage message) {
            this.message = message;
        }

        @Override
        public CollaborationMessage getMessage() {
            return this.message;
        }
    }
}

