/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.ActivationHandler;
import com.vaadin.collaborationengine.BeaconHandler;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.ServiceDestroyDelegate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DeadlockDetectingCompletableFuture;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.LoggerFactory;

public class ComponentConnectionContext
implements ConnectionContext {
    private final Map<Component, Registration> componentListeners = new HashMap<Component, Registration>();
    private final Set<Component> attachedComponents = new HashSet<Component>();
    private volatile UI ui;
    private List<Command> pendingActions = new ArrayList<Command>();
    private ActivationHandler activationHandler;
    private Registration beaconListener;
    private Registration destroyListener;
    private static AtomicBoolean pushCheckDone = new AtomicBoolean(false);

    public ComponentConnectionContext() {
    }

    public ComponentConnectionContext(Component component) {
        this.addComponent(component);
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component can't be null.");
        if (!this.componentListeners.containsKey(component)) {
            Registration attachRegistration = component.addAttachListener((ComponentEventListener & Serializable)event -> this.markAsAttached(event.getUI(), event.getSource()));
            Registration detachRegistration = component.addDetachListener((ComponentEventListener & Serializable)event -> this.markAsDetached(event.getSource()));
            this.componentListeners.put(component, Registration.combine((Registration[])new Registration[]{attachRegistration, detachRegistration}));
            component.getUI().ifPresent(componentUi -> this.markAsAttached((UI)componentUi, component));
        }
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component can't be null.");
        Registration registration = this.componentListeners.remove(component);
        if (registration != null) {
            registration.remove();
            this.markAsDetached(component);
        }
    }

    private void markAsAttached(UI componentUi, Component component) {
        if (this.attachedComponents.add(component)) {
            if (this.attachedComponents.size() == 1) {
                this.ui = componentUi;
                this.checkForPush(this.ui);
                BeaconHandler beaconHandler = BeaconHandler.ensureInstalled(this.ui);
                this.beaconListener = beaconHandler.addListener(this::deactivateConnection);
                ServiceDestroyDelegate destroyDelegate = ServiceDestroyDelegate.ensureInstalled(this.ui);
                this.destroyListener = destroyDelegate.addListener((ServiceDestroyListener & Serializable)event -> this.deactivateConnection());
                this.flushPendingActionsIfActive();
                if (this.activationHandler != null) {
                    this.activationHandler.setActive(true);
                }
            } else if (componentUi != this.ui) {
                throw new IllegalStateException("All components in this connection context must be associated with the same UI.");
            }
        }
    }

    private void markAsDetached(Component component) {
        if (this.attachedComponents.remove(component) && this.attachedComponents.isEmpty()) {
            this.deactivateConnection();
            this.ui = null;
        }
    }

    @Override
    public Registration setActivationHandler(ActivationHandler activationHandler) {
        if (this.activationHandler != null) {
            throw new IllegalStateException("An activation handler has already been set for this context");
        }
        this.activationHandler = Objects.requireNonNull(activationHandler, "Activation handler cannot be null");
        if (this.ui != null) {
            activationHandler.setActive(true);
        }
        return (Registration & Serializable)() -> {
            this.componentListeners.values().forEach(Registration::remove);
            this.componentListeners.clear();
            this.attachedComponents.clear();
            this.ui = null;
        };
    }

    private void deactivateConnection() {
        if (this.beaconListener != null) {
            this.beaconListener.remove();
            this.beaconListener = null;
        }
        if (this.destroyListener != null) {
            this.destroyListener.remove();
            this.destroyListener = null;
        }
        if (this.activationHandler != null) {
            this.activationHandler.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchAction(Command action) {
        List<Command> list = this.pendingActions;
        synchronized (list) {
            this.pendingActions.add(action);
        }
        this.flushPendingActionsIfActive();
    }

    @Override
    public <T> CompletableFuture<T> createCompletableFuture() {
        UI localUI = this.ui;
        if (localUI == null) {
            throw new IllegalStateException("The topic connection within this context maybe deactivated.Make sure the context has at least one component attached to the UI.");
        }
        return new DeadlockDetectingCompletableFuture(localUI.getSession());
    }

    private void flushPendingActionsIfActive() {
        UI localUI = this.ui;
        if (localUI != null) {
            localUI.access((Command & Serializable)() -> {
                ArrayList<Command> pendingActionsCopy;
                List<Command> list = this.pendingActions;
                synchronized (list) {
                    pendingActionsCopy = new ArrayList<Command>(this.pendingActions);
                    this.pendingActions.clear();
                }
                pendingActionsCopy.forEach(Command::execute);
            });
        }
    }

    private void checkForPush(UI ui) {
        boolean checkedBefore = pushCheckDone.getAndSet(true);
        if (!(checkedBefore || ui.getSession().getConfiguration().isProductionMode() || ui.getPushConfiguration().getPushMode().isEnabled())) {
            LoggerFactory.getLogger(ComponentConnectionContext.class).warn("Collaboration Engine is used without server push, so updates can't be propagated in real time. Add @Push annotation on your root layout or individual views to fix this.");
        }
    }
}

