/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.avatar.AvatarGroup;
import com.vaadin.flow.component.avatar.AvatarGroupVariant;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollaborationAvatarGroup
extends Composite<AvatarGroup>
implements HasSize,
HasStyle,
HasTheme {
    static final String MAP_NAME = CollaborationAvatarGroup.class.getName();
    static final String MAP_KEY = "users";
    private final CollaborationEngine ce;
    private Registration topicRegistration;
    private CollaborationMap map;
    private final UserInfo localUser;
    private ImageProvider imageProvider;
    private boolean ownAvatarVisible;

    public CollaborationAvatarGroup(UserInfo localUser, String topicId) {
        this(localUser, topicId, CollaborationEngine.getInstance());
    }

    CollaborationAvatarGroup(UserInfo localUser, String topicId, CollaborationEngine ce) {
        this.localUser = Objects.requireNonNull(localUser, "User cannot be null");
        this.ce = ce;
        this.ownAvatarVisible = true;
        this.refreshItems();
        this.setTopic(topicId);
    }

    public void setTopic(String topicId) {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
        if (topicId != null) {
            this.topicRegistration = this.ce.openTopicConnection(this.getContent(), topicId, this.localUser, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
        }
    }

    public Integer getMaxItemsVisible() {
        return ((AvatarGroup)this.getContent()).getMaxItemsVisible();
    }

    public void setMaxItemsVisible(Integer max) {
        ((AvatarGroup)this.getContent()).setMaxItemsVisible(max);
    }

    public void addThemeVariants(AvatarGroupVariant ... variants) {
        ((AvatarGroup)this.getContent()).addThemeVariants(variants);
    }

    public void removeThemeVariants(AvatarGroupVariant ... variants) {
        ((AvatarGroup)this.getContent()).removeThemeVariants(variants);
    }

    public AvatarGroup.AvatarGroupI18n getI18n() {
        return ((AvatarGroup)this.getContent()).getI18n();
    }

    public void setI18n(AvatarGroup.AvatarGroupI18n i18n) {
        ((AvatarGroup)this.getContent()).setI18n(i18n);
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.map = topicConnection.getNamedMap(MAP_NAME);
        this.updateUsers(this.map, (SerializableFunction<Stream<UserInfo>, Stream<UserInfo>>)(SerializableFunction & Serializable)oldValue -> Stream.concat(oldValue, Stream.of(this.localUser)));
        this.map.subscribe(event -> this.refreshItems());
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        this.updateUsers(this.map, (SerializableFunction<Stream<UserInfo>, Stream<UserInfo>>)(SerializableFunction & Serializable)oldValue -> {
            List users = oldValue.collect(Collectors.toList());
            users.remove(this.localUser);
            return users.stream();
        });
        this.map = null;
        this.refreshItems();
    }

    private void updateUsers(CollaborationMap map, SerializableFunction<Stream<UserInfo>, Stream<UserInfo>> updater) {
        List<UserInfo> oldUsers = map.get(MAP_KEY, JsonUtil.LIST_USER_TYPE_REF);
        Stream<Object> oldUsersStream = oldUsers == null ? Stream.empty() : oldUsers.stream();
        List newUsers = ((Stream)updater.apply(oldUsersStream)).collect(Collectors.toList());
        map.replace(MAP_KEY, oldUsers, newUsers).thenAccept(success -> {
            if (!success.booleanValue()) {
                this.updateUsers(map, updater);
            }
        });
    }

    private void refreshItems() {
        List<UserInfo> users = this.map != null ? this.map.get(MAP_KEY, JsonUtil.LIST_USER_TYPE_REF) : Arrays.asList(this.localUser);
        List items = users != null ? users.stream().distinct().filter(user -> this.ownAvatarVisible || this.isNotLocalUser((UserInfo)user)).map(this::userToAvatarGroupItem).collect(Collectors.toList()) : Collections.emptyList();
        ((AvatarGroup)this.getContent()).setItems(items);
    }

    private AvatarGroup.AvatarGroupItem userToAvatarGroupItem(UserInfo user) {
        AvatarGroup.AvatarGroupItem item = new AvatarGroup.AvatarGroupItem();
        item.setName(user.getName());
        item.setAbbreviation(user.getAbbreviation());
        if (this.imageProvider == null) {
            item.setImage(user.getImage());
        } else {
            item.setImageResource(this.imageProvider.getImageResource(user));
        }
        item.setColorIndex(Integer.valueOf(this.ce.getUserColorIndex(user)));
        return item;
    }

    private boolean isNotLocalUser(UserInfo user) {
        return !this.localUser.equals(user);
    }

    public void setImageProvider(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
        this.refreshItems();
    }

    public ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public boolean isOwnAvatarVisible() {
        return this.ownAvatarVisible;
    }

    public void setOwnAvatarVisible(boolean ownAvatarVisible) {
        this.ownAvatarVisible = ownAvatarVisible;
        this.refreshItems();
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/CollaborationAvatarGroup", (String)"3.1");
    }

    @FunctionalInterface
    public static interface ImageProvider {
        public AbstractStreamResource getImageResource(UserInfo var1);
    }
}

