/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TemplateSelector {
    private final String templateId;
    private final Optional<Map<String, String>> substitutions;

    private TemplateSelector(Builder builder) {
        this.templateId = builder.templateId;
        this.substitutions = builder.substitutions.isEmpty() ? Optional.empty() : Optional.of(builder.substitutions);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Optional<Map<String, String>> getSubstitutions() {
        return this.substitutions;
    }

    public String toString() {
        return "TemplateSelector{templateId='" + this.templateId + '\'' + ", substitutions=" + this.substitutions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateSelector that = (TemplateSelector)o;
        if (!this.substitutions.equals(that.substitutions)) {
            return false;
        }
        return this.templateId.equals(that.templateId);
    }

    public int hashCode() {
        int result = this.templateId.hashCode();
        result = 31 * result + this.substitutions.hashCode();
        return result;
    }

    public static class Builder {
        private String templateId = null;
        private Map<String, String> substitutions = new HashMap<String, String>();

        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder addSubstitution(String var, String value) {
            this.substitutions.put(var, value);
            return this;
        }

        public Builder addSubstitutions(Map<String, String> entries) {
            this.substitutions.putAll(entries);
            return this;
        }

        public TemplateSelector build() {
            Preconditions.checkNotNull((Object)this.templateId, (Object)"You must specify a templateId when building a TemplateSelector");
            return new TemplateSelector(this);
        }
    }
}

