/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.templates.model.TemplateView;
import java.util.List;
import java.util.Optional;

public class TemplateListingResponse {
    private final boolean ok;
    private final Optional<TemplateView> template;
    private final Optional<ImmutableList<TemplateView>> templates;
    private final Optional<Integer> count;
    private final Optional<Integer> totalCount;
    private final Optional<String> nextPage;
    private final Optional<String> prevPage;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private TemplateListingResponse(Builder builder) {
        this.ok = builder.ok;
        this.template = Optional.ofNullable(builder.template);
        this.templates = Optional.ofNullable(builder.templates.build());
        this.count = Optional.ofNullable(builder.count);
        this.totalCount = Optional.ofNullable(builder.totalCount);
        this.nextPage = Optional.ofNullable(builder.nextPage);
        this.prevPage = Optional.ofNullable(builder.prevPage);
        this.error = Optional.ofNullable(builder.error);
        this.errorDetails = Optional.ofNullable(builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<TemplateView> getTemplate() {
        return this.template;
    }

    public Optional<ImmutableList<TemplateView>> getTemplates() {
        return this.templates;
    }

    public Optional<Integer> getCount() {
        return this.count;
    }

    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<String> getPrevPage() {
        return this.prevPage;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "TemplateListingResponse{ok=" + this.ok + ", template=" + this.template + ", templates=" + this.templates + ", count=" + this.count + ", totalCount=" + this.totalCount + ", nextPage=" + this.nextPage + ", prevPage=" + this.prevPage + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateListingResponse that = (TemplateListingResponse)o;
        if (this.ok != that.ok) {
            return false;
        }
        if (!this.count.equals(that.count)) {
            return false;
        }
        if (!this.nextPage.equals(that.nextPage)) {
            return false;
        }
        if (!this.prevPage.equals(that.prevPage)) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        if (!this.templates.equals(that.templates)) {
            return false;
        }
        if (!this.totalCount.equals(that.totalCount)) {
            return false;
        }
        if (!this.error.equals(that.error)) {
            return false;
        }
        return this.errorDetails.equals(that.errorDetails);
    }

    public int hashCode() {
        int result = this.ok ? 1 : 0;
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.templates.hashCode();
        result = 31 * result + this.count.hashCode();
        result = 31 * result + this.totalCount.hashCode();
        result = 31 * result + this.nextPage.hashCode();
        result = 31 * result + this.prevPage.hashCode();
        result = 31 * result + this.error.hashCode();
        result = 31 * result + this.errorDetails.hashCode();
        return result;
    }

    public static class Builder {
        private boolean ok;
        private TemplateView template = null;
        private ImmutableList.Builder<TemplateView> templates = ImmutableList.builder();
        private Integer count = null;
        private Integer totalCount = null;
        private String nextPage = null;
        private String prevPage = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setTemplate(TemplateView template) {
            this.template = template;
            return this;
        }

        public Builder setTemplates(List<TemplateView> templates) {
            this.templates.addAll(templates);
            return this;
        }

        public Builder setCount(Integer count) {
            this.count = count;
            return this;
        }

        public Builder setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder setNextPage(String nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public Builder setPrevPage(String prevPage) {
            this.prevPage = prevPage;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public TemplateListingResponse build() {
            if (!this.templates.build().isEmpty()) {
                Preconditions.checkArgument((this.template == null && this.count != null && this.totalCount != null ? 1 : 0) != 0);
            }
            return new TemplateListingResponse(this);
        }
    }
}

