/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.templates.model.PartialPushPayload;
import com.urbanairship.api.templates.model.TemplateResponse;
import com.urbanairship.api.templates.model.TemplateVariable;
import com.urbanairship.api.templates.model.TemplateView;
import com.urbanairship.api.templates.parse.TemplatesObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TemplateRequest
implements Request<TemplateResponse> {
    private static final String API_POST_TEMPLATE = "/api/templates/";
    private final TemplateView.Builder builder = TemplateView.newBuilder();
    private final String path;

    private TemplateRequest(String path) {
        this.path = path;
    }

    public static TemplateRequest newRequest() {
        return new TemplateRequest(API_POST_TEMPLATE);
    }

    public static TemplateRequest newRequest(String templateId) {
        return new TemplateRequest(API_POST_TEMPLATE + templateId);
    }

    public TemplateRequest setName(String name) {
        this.builder.setName(name);
        return this;
    }

    public TemplateRequest setDescription(String description) {
        this.builder.setDescription(description);
        return this;
    }

    public TemplateRequest addVariable(TemplateVariable variable) {
        this.builder.addVariable(variable);
        return this;
    }

    public TemplateRequest addAllVariables(List<TemplateVariable> variables) {
        this.builder.addAllVariables(variables);
        return this;
    }

    public TemplateRequest setPush(PartialPushPayload push) {
        this.builder.setPushPayload(push);
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        ObjectMapper mapper = TemplatesObjectMapper.getInstance().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return mapper.writeValueAsString((Object)this.builder.build());
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<TemplateResponse> getResponseParser() {
        return response -> (TemplateResponse)TemplatesObjectMapper.getInstance().readValue(response, TemplateResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

