/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.templates.model.TemplateListingResponse;
import com.urbanairship.api.templates.parse.TemplatesObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

public class TemplateListingRequest
implements Request<TemplateListingResponse> {
    private static final String API_TEMPLATES_GET = "/api/templates/";
    private final String path;
    private Integer page;
    private Integer pageSize;

    private TemplateListingRequest(String path) {
        this.path = path;
    }

    public static TemplateListingRequest newRequest() {
        return new TemplateListingRequest(API_TEMPLATES_GET);
    }

    public static TemplateListingRequest newRequest(String templateId) {
        return new TemplateListingRequest(API_TEMPLATES_GET + templateId);
    }

    public TemplateListingRequest setPage(int page) {
        this.page = page;
        return this;
    }

    public TemplateListingRequest setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (this.page != null) {
            builder.addParameter("page", this.page.toString());
        }
        if (this.pageSize != null) {
            builder.addParameter("page_size", this.pageSize.toString());
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<TemplateListingResponse> getResponseParser() {
        return response -> (TemplateListingResponse)TemplatesObjectMapper.getInstance().readValue(response, TemplateListingResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

